/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.network.PacketByteBuf;

public final class PacketByteBufs {
    private static final PacketByteBuf EMPTY_PACKET_BYTE_BUF = new PacketByteBuf(Unpooled.EMPTY_BUFFER);

    public static PacketByteBuf empty() {
        return EMPTY_PACKET_BYTE_BUF;
    }

    public static PacketByteBuf create() {
        return new PacketByteBuf(Unpooled.buffer());
    }

    public static PacketByteBuf readBytes(ByteBuf buf, int length) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.readBytes(length));
    }

    public static PacketByteBuf readSlice(ByteBuf buf, int length) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.readSlice(length));
    }

    public static PacketByteBuf readRetainedSlice(ByteBuf buf, int length) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.readRetainedSlice(length));
    }

    public static PacketByteBuf copy(ByteBuf buf) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.copy());
    }

    public static PacketByteBuf copy(ByteBuf buf, int index, int length) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.copy(index, length));
    }

    public static PacketByteBuf slice(ByteBuf buf) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.slice());
    }

    public static PacketByteBuf retainedSlice(ByteBuf buf) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.retainedSlice());
    }

    public static PacketByteBuf slice(ByteBuf buf, int index, int length) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.slice(index, length));
    }

    public static PacketByteBuf retainedSlice(ByteBuf buf, int index, int length) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.retainedSlice(index, length));
    }

    public static PacketByteBuf duplicate(ByteBuf buf) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.duplicate());
    }

    public static PacketByteBuf retainedDuplicate(ByteBuf buf) {
        Objects.requireNonNull(buf, "ByteBuf cannot be null");
        return new PacketByteBuf(buf.retainedDuplicate());
    }

    private PacketByteBufs() {
    }
}

