/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.screen;

import java.util.AbstractList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.Drawable;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.Selectable;
import net.minecraft.client.gui.widget.ClickableWidget;

@Environment(value=EnvType.CLIENT)
public final class ButtonList
extends AbstractList<ClickableWidget> {
    private final List<Drawable> drawables;
    private final List<Selectable> selectables;
    private final List<Element> children;

    public ButtonList(List<Drawable> drawables, List<Selectable> selectables, List<Element> children) {
        this.drawables = drawables;
        this.selectables = selectables;
        this.children = children;
    }

    @Override
    public ClickableWidget get(int index) {
        int drawableIndex = this.translateIndex(this.drawables, index, false);
        return (ClickableWidget)this.drawables.get(drawableIndex);
    }

    @Override
    public ClickableWidget set(int index, ClickableWidget element) {
        int drawableIndex = this.translateIndex(this.drawables, index, false);
        this.drawables.set(drawableIndex, (Drawable)element);
        int selectableIndex = this.translateIndex(this.selectables, index, false);
        this.selectables.set(selectableIndex, (Selectable)element);
        int childIndex = this.translateIndex(this.children, index, false);
        return (ClickableWidget)this.children.set(childIndex, (Element)element);
    }

    @Override
    public void add(int index, ClickableWidget element) {
        int duplicateIndex = this.drawables.indexOf(element);
        if (duplicateIndex >= 0) {
            this.drawables.remove(element);
            this.selectables.remove(element);
            this.children.remove(element);
            if (duplicateIndex <= this.translateIndex(this.drawables, index, true)) {
                --index;
            }
        }
        int drawableIndex = this.translateIndex(this.drawables, index, true);
        this.drawables.add(drawableIndex, (Drawable)element);
        int selectableIndex = this.translateIndex(this.selectables, index, true);
        this.selectables.add(selectableIndex, (Selectable)element);
        int childIndex = this.translateIndex(this.children, index, true);
        this.children.add(childIndex, (Element)element);
    }

    @Override
    public ClickableWidget remove(int index) {
        index = this.translateIndex(this.drawables, index, false);
        ClickableWidget removedButton = (ClickableWidget)this.drawables.remove(index);
        this.selectables.remove(removedButton);
        this.children.remove(removedButton);
        return removedButton;
    }

    @Override
    public int size() {
        int ret = 0;
        for (Drawable drawable : this.drawables) {
            if (!(drawable instanceof ClickableWidget)) continue;
            ++ret;
        }
        return ret;
    }

    private int translateIndex(List<?> list, int index, boolean allowAfter) {
        int remaining = index;
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            if (!(list.get(i) instanceof ClickableWidget)) continue;
            if (remaining == 0) {
                return i;
            }
            --remaining;
        }
        if (allowAfter && remaining == 0) {
            return list.size();
        }
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, index - remaining));
    }
}

