/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.screen.v1;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.impl.client.screen.ScreenExtensions;
import net.minecraft.client.gui.screen.Screen;

@Environment(value=EnvType.CLIENT)
public final class ScreenMouseEvents {
    public static Event<AllowMouseClick> allowMouseClick(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAllowMouseClickEvent();
    }

    public static Event<BeforeMouseClick> beforeMouseClick(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getBeforeMouseClickEvent();
    }

    public static Event<AfterMouseClick> afterMouseClick(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAfterMouseClickEvent();
    }

    public static Event<AllowMouseRelease> allowMouseRelease(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAllowMouseReleaseEvent();
    }

    public static Event<BeforeMouseRelease> beforeMouseRelease(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getBeforeMouseReleaseEvent();
    }

    public static Event<AfterMouseRelease> afterMouseRelease(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAfterMouseReleaseEvent();
    }

    public static Event<AllowMouseScroll> allowMouseScroll(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAllowMouseScrollEvent();
    }

    public static Event<BeforeMouseScroll> beforeMouseScroll(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getBeforeMouseScrollEvent();
    }

    public static Event<AfterMouseScroll> afterMouseScroll(Screen screen) {
        Objects.requireNonNull(screen, "Screen cannot be null");
        return ScreenExtensions.getExtensions(screen).fabric_getAfterMouseScrollEvent();
    }

    private ScreenMouseEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterMouseScroll {
        public void afterMouseScroll(Screen var1, double var2, double var4, double var6, double var8);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeMouseScroll {
        public void beforeMouseScroll(Screen var1, double var2, double var4, double var6, double var8);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowMouseScroll {
        public boolean allowMouseScroll(Screen var1, double var2, double var4, double var6, double var8);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterMouseRelease {
        public void afterMouseRelease(Screen var1, double var2, double var4, int var6);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeMouseRelease {
        public void beforeMouseRelease(Screen var1, double var2, double var4, int var6);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowMouseRelease {
        public boolean allowMouseRelease(Screen var1, double var2, double var4, int var6);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AfterMouseClick {
        public void afterMouseClick(Screen var1, double var2, double var4, int var6);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface BeforeMouseClick {
        public void beforeMouseClick(Screen var1, double var2, double var4, int var6);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowMouseClick {
        public boolean allowMouseClick(Screen var1, double var2, double var4, int var6);
    }
}

