/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantCache;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.registry.Registries;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemVariantImpl
implements ItemVariant {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/item");
    private final Item item;
    @Nullable
    private final NbtCompound nbt;
    private final int hashCode;
    @Nullable
    private volatile ItemStack cachedStack = null;

    public static ItemVariant of(Item item, @Nullable NbtCompound tag) {
        Objects.requireNonNull(item, "Item may not be null.");
        if (tag == null || item == Items.AIR) {
            return ((ItemVariantCache)item).fabric_getCachedItemVariant();
        }
        return new ItemVariantImpl(item, tag);
    }

    public ItemVariantImpl(Item item, NbtCompound nbt) {
        this.item = item;
        this.nbt = nbt == null ? null : nbt.copy();
        this.hashCode = Objects.hash(item, nbt);
    }

    @Override
    public Item getObject() {
        return this.item;
    }

    @Override
    @Nullable
    public NbtCompound getNbt() {
        return this.nbt;
    }

    @Override
    public boolean isBlank() {
        return this.item == Items.AIR;
    }

    @Override
    public NbtCompound toNbt() {
        NbtCompound result = new NbtCompound();
        result.putString("item", Registries.ITEM.getId((Object)this.item).toString());
        if (this.nbt != null) {
            result.put("tag", (NbtElement)this.nbt.copy());
        }
        return result;
    }

    public static ItemVariant fromNbt(NbtCompound tag) {
        try {
            Item item = (Item)Registries.ITEM.get(new Identifier(tag.getString("item")));
            NbtCompound aTag = tag.contains("tag") ? tag.getCompound("tag") : null;
            return ItemVariantImpl.of(item, aTag);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Tried to load an invalid ItemVariant from NBT: {}", (Object)tag, (Object)runtimeException);
            return ItemVariant.blank();
        }
    }

    @Override
    public void toPacket(PacketByteBuf buf) {
        if (this.isBlank()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeVarInt(Item.getRawId((Item)this.item));
            buf.writeNbt(this.nbt);
        }
    }

    public static ItemVariant fromPacket(PacketByteBuf buf) {
        if (!buf.readBoolean()) {
            return ItemVariant.blank();
        }
        Item item = Item.byRawId((int)buf.readVarInt());
        NbtCompound nbt = buf.readNbt();
        return ItemVariantImpl.of(item, nbt);
    }

    public String toString() {
        return "ItemVariant{item=" + String.valueOf(this.item) + ", tag=" + String.valueOf(this.nbt) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariantImpl ItemVariant2 = (ItemVariantImpl)o;
        return this.hashCode == ItemVariant2.hashCode && this.item == ItemVariant2.item && this.nbtMatches(ItemVariant2.nbt);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public ItemStack getCachedStack() {
        ItemStack ret = this.cachedStack;
        if (ret == null) {
            this.cachedStack = ret = this.toStack();
        }
        return ret;
    }
}

