/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.fluid;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtil;
import net.minecraft.potion.Potions;
import org.jetbrains.annotations.Nullable;

public class WaterPotionStorage
implements ExtractionOnlyStorage<FluidVariant>,
SingleSlotStorage<FluidVariant> {
    private static final FluidVariant CONTAINED_FLUID = FluidVariant.of((Fluid)Fluids.WATER);
    private static final long CONTAINED_AMOUNT = 27000L;
    private final ContainerItemContext context;

    @Nullable
    public static WaterPotionStorage find(ContainerItemContext context) {
        return WaterPotionStorage.isWaterPotion(context) ? new WaterPotionStorage(context) : null;
    }

    private static boolean isWaterPotion(ContainerItemContext context) {
        ItemVariant variant = context.getItemVariant();
        return variant.isOf(Items.POTION) && PotionUtil.getPotion((NbtCompound)variant.getNbt()) == Potions.WATER;
    }

    private WaterPotionStorage(ContainerItemContext context) {
        this.context = context;
    }

    private boolean isWaterPotion() {
        return WaterPotionStorage.isWaterPotion(this.context);
    }

    private ItemVariant mapToGlassBottle() {
        ItemStack newStack = this.context.getItemVariant().toStack();
        PotionUtil.setPotion((ItemStack)newStack, (Potion)Potions.EMPTY);
        return ItemVariant.of((ItemConvertible)Items.GLASS_BOTTLE, newStack.getNbt());
    }

    @Override
    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, maxAmount);
        if (!this.isWaterPotion()) {
            return 0L;
        }
        if (resource.equals(CONTAINED_FLUID) && maxAmount >= 27000L && this.context.exchange(this.mapToGlassBottle(), 1L, transaction) == 1L) {
            return 27000L;
        }
        return 0L;
    }

    @Override
    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    @Override
    public FluidVariant getResource() {
        if (this.isWaterPotion()) {
            return CONTAINED_FLUID;
        }
        return FluidVariant.blank();
    }

    @Override
    public long getAmount() {
        if (this.isWaterPotion()) {
            return 27000L;
        }
        return 0L;
    }

    @Override
    public long getCapacity() {
        return this.getAmount();
    }

    public String toString() {
        return "WaterPotionStorage[" + String.valueOf(this.context) + "]";
    }
}

