/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.fluid;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantCache;
import net.minecraft.fluid.FlowableFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.registry.Registries;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidVariantImpl
implements FluidVariant {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/fluid");
    private final Fluid fluid;
    @Nullable
    private final NbtCompound nbt;
    private final int hashCode;

    public static FluidVariant of(Fluid fluid, @Nullable NbtCompound nbt) {
        Objects.requireNonNull(fluid, "Fluid may not be null.");
        if (!fluid.isStill(fluid.getDefaultState()) && fluid != Fluids.EMPTY) {
            if (fluid instanceof FlowableFluid) {
                FlowableFluid flowable = (FlowableFluid)fluid;
                fluid = flowable.getStill();
            } else {
                Identifier id = Registries.FLUID.getId((Object)fluid);
                throw new IllegalArgumentException("Cannot convert flowing fluid %s (%s) into a still fluid.".formatted(id, fluid));
            }
        }
        if (nbt == null || fluid == Fluids.EMPTY) {
            return ((FluidVariantCache)fluid).fabric_getCachedFluidVariant();
        }
        return new FluidVariantImpl(fluid, nbt);
    }

    public FluidVariantImpl(Fluid fluid, NbtCompound nbt) {
        this.fluid = fluid;
        this.nbt = nbt == null ? null : nbt.copy();
        this.hashCode = Objects.hash(fluid, nbt);
    }

    @Override
    public boolean isBlank() {
        return this.fluid == Fluids.EMPTY;
    }

    @Override
    public Fluid getObject() {
        return this.fluid;
    }

    @Override
    @Nullable
    public NbtCompound getNbt() {
        return this.nbt;
    }

    @Override
    public NbtCompound toNbt() {
        NbtCompound result = new NbtCompound();
        result.putString("fluid", Registries.FLUID.getId((Object)this.fluid).toString());
        if (this.nbt != null) {
            result.put("tag", (NbtElement)this.nbt.copy());
        }
        return result;
    }

    public static FluidVariant fromNbt(NbtCompound compound) {
        try {
            Fluid fluid = (Fluid)Registries.FLUID.get(new Identifier(compound.getString("fluid")));
            NbtCompound nbt = compound.contains("tag") ? compound.getCompound("tag") : null;
            return FluidVariantImpl.of(fluid, nbt);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Tried to load an invalid FluidVariant from NBT: {}", (Object)compound, (Object)runtimeException);
            return FluidVariant.blank();
        }
    }

    @Override
    public void toPacket(PacketByteBuf buf) {
        if (this.isBlank()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeVarInt(Registries.FLUID.getRawId((Object)this.fluid));
            buf.writeNbt(this.nbt);
        }
    }

    public static FluidVariant fromPacket(PacketByteBuf buf) {
        if (!buf.readBoolean()) {
            return FluidVariant.blank();
        }
        Fluid fluid = (Fluid)Registries.FLUID.get(buf.readVarInt());
        NbtCompound nbt = buf.readNbt();
        return FluidVariantImpl.of(fluid, nbt);
    }

    public String toString() {
        return "FluidVariant{fluid=" + String.valueOf(this.fluid) + ", tag=" + String.valueOf(this.nbt) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidVariantImpl fluidVariant = (FluidVariantImpl)o;
        return this.hashCode == fluidVariant.hashCode && this.fluid == fluidVariant.fluid && this.nbtMatches(fluidVariant.nbt);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

