/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resource.metadata;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.resource.metadata.AnimationFrameResourceMetadata;
import net.minecraft.client.resource.metadata.AnimationResourceMetadata;
import net.minecraft.resource.metadata.ResourceMetadataReader;
import net.minecraft.util.JsonHelper;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AnimationResourceMetadataReader
implements ResourceMetadataReader<AnimationResourceMetadata> {
    public AnimationResourceMetadata fromJson(JsonObject jsonObject) {
        int j;
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = JsonHelper.getInt((JsonObject)jsonObject, (String)"frametime", (int)1);
        if (i != 1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)i, (String)"Invalid default frame time");
        }
        if (jsonObject.has("frames")) {
            try {
                JsonArray jsonArray = JsonHelper.getArray((JsonObject)jsonObject, (String)"frames");
                for (j = 0; j < jsonArray.size(); ++j) {
                    JsonElement jsonElement = jsonArray.get(j);
                    AnimationFrameResourceMetadata animationFrameResourceMetadata = this.readFrameMetadata(j, jsonElement);
                    if (animationFrameResourceMetadata == null) continue;
                    builder.add((Object)animationFrameResourceMetadata);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JsonParseException("Invalid animation->frames: expected array, was " + jsonObject.get("frames"), (Throwable)classCastException);
            }
        }
        int k = JsonHelper.getInt((JsonObject)jsonObject, (String)"width", (int)-1);
        j = JsonHelper.getInt((JsonObject)jsonObject, (String)"height", (int)-1);
        if (k != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)k, (String)"Invalid width");
        }
        if (j != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)j, (String)"Invalid height");
        }
        boolean bl = JsonHelper.getBoolean((JsonObject)jsonObject, (String)"interpolate", (boolean)false);
        return new AnimationResourceMetadata((List<AnimationFrameResourceMetadata>)builder.build(), k, j, i, bl);
    }

    @Nullable
    private AnimationFrameResourceMetadata readFrameMetadata(int frame, JsonElement json) {
        if (json.isJsonPrimitive()) {
            return new AnimationFrameResourceMetadata(JsonHelper.asInt((JsonElement)json, (String)("frames[" + frame + "]")));
        }
        if (json.isJsonObject()) {
            JsonObject jsonObject = JsonHelper.asObject((JsonElement)json, (String)("frames[" + frame + "]"));
            int i = JsonHelper.getInt((JsonObject)jsonObject, (String)"time", (int)-1);
            if (jsonObject.has("time")) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)i, (String)"Invalid frame time");
            }
            int j = JsonHelper.getInt((JsonObject)jsonObject, (String)"index");
            Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)j, (String)"Invalid frame index");
            return new AnimationFrameResourceMetadata(j, i);
        }
        return null;
    }

    public String getKey() {
        return "animation";
    }

    public /* synthetic */ Object fromJson(JsonObject json) {
        return this.fromJson(json);
    }
}

