/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity.feature;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.network.AbstractClientPlayerEntity;
import net.minecraft.client.render.OverlayTexture;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.entity.PlayerModelPart;
import net.minecraft.client.render.entity.feature.FeatureRenderer;
import net.minecraft.client.render.entity.feature.FeatureRendererContext;
import net.minecraft.client.render.entity.model.PlayerEntityModel;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RotationAxis;

@Environment(value=EnvType.CLIENT)
public class CapeFeatureRenderer
extends FeatureRenderer<AbstractClientPlayerEntity, PlayerEntityModel<AbstractClientPlayerEntity>> {
    public CapeFeatureRenderer(FeatureRendererContext<AbstractClientPlayerEntity, PlayerEntityModel<AbstractClientPlayerEntity>> featureRendererContext) {
        super(featureRendererContext);
    }

    @Override
    public void render(MatrixStack matrixStack, VertexConsumerProvider vertexConsumerProvider, int i, AbstractClientPlayerEntity abstractClientPlayerEntity, float f, float g, float h, float j, float k, float l) {
        if (!abstractClientPlayerEntity.canRenderCapeTexture() || abstractClientPlayerEntity.isInvisible() || !abstractClientPlayerEntity.isPartVisible(PlayerModelPart.CAPE) || abstractClientPlayerEntity.getCapeTexture() == null) {
            return;
        }
        ItemStack itemStack = abstractClientPlayerEntity.getEquippedStack(EquipmentSlot.CHEST);
        if (itemStack.isOf(Items.ELYTRA)) {
            return;
        }
        matrixStack.push();
        matrixStack.translate(0.0f, 0.0f, 0.125f);
        double d = MathHelper.lerp((double)h, (double)abstractClientPlayerEntity.prevCapeX, (double)abstractClientPlayerEntity.capeX) - MathHelper.lerp((double)h, (double)abstractClientPlayerEntity.prevX, (double)abstractClientPlayerEntity.getX());
        double e = MathHelper.lerp((double)h, (double)abstractClientPlayerEntity.prevCapeY, (double)abstractClientPlayerEntity.capeY) - MathHelper.lerp((double)h, (double)abstractClientPlayerEntity.prevY, (double)abstractClientPlayerEntity.getY());
        double m = MathHelper.lerp((double)h, (double)abstractClientPlayerEntity.prevCapeZ, (double)abstractClientPlayerEntity.capeZ) - MathHelper.lerp((double)h, (double)abstractClientPlayerEntity.prevZ, (double)abstractClientPlayerEntity.getZ());
        float n = MathHelper.lerpAngleDegrees((float)h, (float)abstractClientPlayerEntity.prevBodyYaw, (float)abstractClientPlayerEntity.bodyYaw);
        double o = MathHelper.sin((float)(n * ((float)Math.PI / 180)));
        double p = -MathHelper.cos((float)(n * ((float)Math.PI / 180)));
        float q = (float)e * 10.0f;
        q = MathHelper.clamp((float)q, (float)-6.0f, (float)32.0f);
        float r = (float)(d * o + m * p) * 100.0f;
        r = MathHelper.clamp((float)r, (float)0.0f, (float)150.0f);
        float s = (float)(d * p - m * o) * 100.0f;
        s = MathHelper.clamp((float)s, (float)-20.0f, (float)20.0f);
        if (r < 0.0f) {
            r = 0.0f;
        }
        float t = MathHelper.lerp((float)h, (float)abstractClientPlayerEntity.prevStrideDistance, (float)abstractClientPlayerEntity.strideDistance);
        q += MathHelper.sin((float)(MathHelper.lerp((float)h, (float)abstractClientPlayerEntity.prevHorizontalSpeed, (float)abstractClientPlayerEntity.horizontalSpeed) * 6.0f)) * 32.0f * t;
        if (abstractClientPlayerEntity.isInSneakingPose()) {
            q += 25.0f;
        }
        matrixStack.multiply(RotationAxis.POSITIVE_X.rotationDegrees(6.0f + r / 2.0f + q));
        matrixStack.multiply(RotationAxis.POSITIVE_Z.rotationDegrees(s / 2.0f));
        matrixStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(180.0f - s / 2.0f));
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderLayer.getEntitySolid(abstractClientPlayerEntity.getCapeTexture()));
        ((PlayerEntityModel)this.getContextModel()).renderCape(matrixStack, vertexConsumer, i, OverlayTexture.DEFAULT_UV);
        matrixStack.pop();
    }
}

