/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.OverlayTexture;
import net.minecraft.client.render.TexturedRenderLayers;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.block.BlockRenderManager;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.EntityRendererFactory;
import net.minecraft.client.render.item.ItemRenderer;
import net.minecraft.client.render.model.BakedModelManager;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.client.texture.SpriteAtlasTexture;
import net.minecraft.client.util.ModelIdentifier;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.decoration.ItemFrameEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.map.MapState;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.RotationAxis;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

@Environment(value=EnvType.CLIENT)
public class ItemFrameEntityRenderer<T extends ItemFrameEntity>
extends EntityRenderer<T> {
    private static final ModelIdentifier NORMAL_FRAME = ModelIdentifier.ofVanilla("item_frame", "map=false");
    private static final ModelIdentifier MAP_FRAME = ModelIdentifier.ofVanilla("item_frame", "map=true");
    private static final ModelIdentifier GLOW_FRAME = ModelIdentifier.ofVanilla("glow_item_frame", "map=false");
    private static final ModelIdentifier MAP_GLOW_FRAME = ModelIdentifier.ofVanilla("glow_item_frame", "map=true");
    public static final int GLOW_FRAME_BLOCK_LIGHT = 5;
    public static final int field_32933 = 30;
    private final ItemRenderer itemRenderer;
    private final BlockRenderManager blockRenderManager;

    public ItemFrameEntityRenderer(EntityRendererFactory.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
        this.blockRenderManager = context.getBlockRenderManager();
    }

    @Override
    protected int getBlockLight(T itemFrameEntity, BlockPos blockPos) {
        if (itemFrameEntity.getType() == EntityType.GLOW_ITEM_FRAME) {
            return Math.max(5, super.getBlockLight(itemFrameEntity, blockPos));
        }
        return super.getBlockLight(itemFrameEntity, blockPos);
    }

    @Override
    public void render(T itemFrameEntity, float f, float g, MatrixStack matrixStack, VertexConsumerProvider vertexConsumerProvider, int i) {
        super.render(itemFrameEntity, f, g, matrixStack, vertexConsumerProvider, i);
        matrixStack.push();
        Direction direction = itemFrameEntity.getHorizontalFacing();
        Vec3d vec3d = this.getPositionOffset(itemFrameEntity, g);
        matrixStack.translate(-vec3d.getX(), -vec3d.getY(), -vec3d.getZ());
        double d = 0.46875;
        matrixStack.translate((double)direction.getOffsetX() * 0.46875, (double)direction.getOffsetY() * 0.46875, (double)direction.getOffsetZ() * 0.46875);
        matrixStack.multiply(RotationAxis.POSITIVE_X.rotationDegrees(itemFrameEntity.getPitch()));
        matrixStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(180.0f - itemFrameEntity.getYaw()));
        boolean bl = itemFrameEntity.isInvisible();
        ItemStack itemStack = itemFrameEntity.getHeldItemStack();
        if (!bl) {
            BakedModelManager bakedModelManager = this.blockRenderManager.getModels().getModelManager();
            ModelIdentifier modelIdentifier = this.getModelId(itemFrameEntity, itemStack);
            matrixStack.push();
            matrixStack.translate(-0.5f, -0.5f, -0.5f);
            this.blockRenderManager.getModelRenderer().render(matrixStack.peek(), vertexConsumerProvider.getBuffer(TexturedRenderLayers.getEntitySolid()), null, bakedModelManager.getModel(modelIdentifier), 1.0f, 1.0f, 1.0f, i, OverlayTexture.DEFAULT_UV);
            matrixStack.pop();
        }
        if (!itemStack.isEmpty()) {
            OptionalInt optionalInt = itemFrameEntity.getMapId();
            if (bl) {
                matrixStack.translate(0.0f, 0.0f, 0.5f);
            } else {
                matrixStack.translate(0.0f, 0.0f, 0.4375f);
            }
            int j = optionalInt.isPresent() ? itemFrameEntity.getRotation() % 4 * 2 : itemFrameEntity.getRotation();
            matrixStack.multiply(RotationAxis.POSITIVE_Z.rotationDegrees((float)j * 360.0f / 8.0f));
            if (optionalInt.isPresent()) {
                matrixStack.multiply(RotationAxis.POSITIVE_Z.rotationDegrees(180.0f));
                float h = 0.0078125f;
                matrixStack.scale(0.0078125f, 0.0078125f, 0.0078125f);
                matrixStack.translate(-64.0f, -64.0f, 0.0f);
                MapState mapState = FilledMapItem.getMapState((Integer)optionalInt.getAsInt(), (World)itemFrameEntity.getWorld());
                matrixStack.translate(0.0f, 0.0f, -1.0f);
                if (mapState != null) {
                    int k = this.getLight(itemFrameEntity, 15728850, i);
                    MinecraftClient.getInstance().gameRenderer.getMapRenderer().draw(matrixStack, vertexConsumerProvider, optionalInt.getAsInt(), mapState, true, k);
                }
            } else {
                int l = this.getLight(itemFrameEntity, 0xF000F0, i);
                matrixStack.scale(0.5f, 0.5f, 0.5f);
                this.itemRenderer.renderItem(itemStack, ModelTransformationMode.FIXED, l, OverlayTexture.DEFAULT_UV, matrixStack, vertexConsumerProvider, itemFrameEntity.getWorld(), itemFrameEntity.getId());
            }
        }
        matrixStack.pop();
    }

    private int getLight(T itemFrame, int glowLight, int regularLight) {
        return itemFrame.getType() == EntityType.GLOW_ITEM_FRAME ? glowLight : regularLight;
    }

    private ModelIdentifier getModelId(T entity, ItemStack stack) {
        boolean bl;
        boolean bl2 = bl = entity.getType() == EntityType.GLOW_ITEM_FRAME;
        if (stack.isOf(Items.FILLED_MAP)) {
            return bl ? MAP_GLOW_FRAME : MAP_FRAME;
        }
        return bl ? GLOW_FRAME : NORMAL_FRAME;
    }

    @Override
    public Vec3d getPositionOffset(T itemFrameEntity, float f) {
        return new Vec3d((double)((float)itemFrameEntity.getHorizontalFacing().getOffsetX() * 0.3f), -0.25, (double)((float)itemFrameEntity.getHorizontalFacing().getOffsetZ() * 0.3f));
    }

    @Override
    public Identifier getTexture(T itemFrameEntity) {
        return SpriteAtlasTexture.BLOCK_ATLAS_TEXTURE;
    }

    @Override
    protected boolean hasLabel(T itemFrameEntity) {
        if (!MinecraftClient.isHudEnabled() || itemFrameEntity.getHeldItemStack().isEmpty() || !itemFrameEntity.getHeldItemStack().hasCustomName() || this.dispatcher.targetedEntity != itemFrameEntity) {
            return false;
        }
        double d = this.dispatcher.getSquaredDistanceToCamera((Entity)itemFrameEntity);
        float f = itemFrameEntity.isSneaky() ? 32.0f : 64.0f;
        return d < (double)(f * f);
    }

    @Override
    protected void renderLabelIfPresent(T itemFrameEntity, Text text, MatrixStack matrixStack, VertexConsumerProvider vertexConsumerProvider, int i) {
        super.renderLabelIfPresent(itemFrameEntity, itemFrameEntity.getHeldItemStack().getName(), matrixStack, vertexConsumerProvider, i);
    }
}

