/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.debug;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.debug.DebugRenderer;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.fluid.FluidState;
import net.minecraft.registry.tag.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Box;
import net.minecraft.world.BlockView;
import net.minecraft.world.World;

@Environment(value=EnvType.CLIENT)
public class WaterDebugRenderer
implements DebugRenderer.Renderer {
    private final MinecraftClient client;

    public WaterDebugRenderer(MinecraftClient client) {
        this.client = client;
    }

    @Override
    public void render(MatrixStack matrices, VertexConsumerProvider vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        FluidState fluidState;
        BlockPos blockPos = this.client.player.getBlockPos();
        World worldView = this.client.player.getWorld();
        for (BlockPos blockPos2 : BlockPos.iterate((BlockPos)blockPos.add(-10, -10, -10), (BlockPos)blockPos.add(10, 10, 10))) {
            fluidState = worldView.getFluidState(blockPos2);
            if (!fluidState.isIn(FluidTags.WATER)) continue;
            double d = (float)blockPos2.getY() + fluidState.getHeight((BlockView)worldView, blockPos2);
            DebugRenderer.drawBox(matrices, vertexConsumers, new Box((double)((float)blockPos2.getX() + 0.01f), (double)((float)blockPos2.getY() + 0.01f), (double)((float)blockPos2.getZ() + 0.01f), (double)((float)blockPos2.getX() + 0.99f), d, (double)((float)blockPos2.getZ() + 0.99f)).offset(-cameraX, -cameraY, -cameraZ), 0.0f, 1.0f, 0.0f, 0.15f);
        }
        for (BlockPos blockPos2 : BlockPos.iterate((BlockPos)blockPos.add(-10, -10, -10), (BlockPos)blockPos.add(10, 10, 10))) {
            fluidState = worldView.getFluidState(blockPos2);
            if (!fluidState.isIn(FluidTags.WATER)) continue;
            DebugRenderer.drawString(matrices, vertexConsumers, String.valueOf(fluidState.getLevel()), (double)blockPos2.getX() + 0.5, (float)blockPos2.getY() + fluidState.getHeight((BlockView)worldView, blockPos2), (double)blockPos2.getZ() + 0.5, -16777216);
        }
    }
}

