/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.debug;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.ShapeContext;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.debug.DebugRenderer;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BlockView;

@Environment(value=EnvType.CLIENT)
public class SupportingBlockDebugRenderer
implements DebugRenderer.Renderer {
    private final MinecraftClient client;
    private double lastEntityCheckTime = Double.MIN_VALUE;
    private List<Entity> entities = Collections.emptyList();

    public SupportingBlockDebugRenderer(MinecraftClient client) {
        this.client = client;
    }

    @Override
    public void render(MatrixStack matrices, VertexConsumerProvider vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        ClientPlayerEntity playerEntity;
        double d = Util.getMeasuringTimeNano();
        if (d - this.lastEntityCheckTime > 1.0E8) {
            this.lastEntityCheckTime = d;
            Entity entity = this.client.gameRenderer.getCamera().getFocusedEntity();
            this.entities = ImmutableList.copyOf((Collection)entity.getWorld().getOtherEntities(entity, entity.getBoundingBox().expand(16.0)));
        }
        if ((playerEntity = this.client.player) != null && playerEntity.supportingBlockPos.isPresent()) {
            this.renderBlockHighlights(matrices, vertexConsumers, cameraX, cameraY, cameraZ, (Entity)playerEntity, () -> 0.0, 1.0f, 0.0f, 0.0f);
        }
        for (Entity entity2 : this.entities) {
            if (entity2 == playerEntity) continue;
            this.renderBlockHighlights(matrices, vertexConsumers, cameraX, cameraY, cameraZ, entity2, () -> this.getAdditionalDilation(entity2), 0.0f, 1.0f, 0.0f);
        }
    }

    private void renderBlockHighlights(MatrixStack matrices, VertexConsumerProvider vertexConsumers, double cameraX, double cameraY, double cameraZ, Entity entity, DoubleSupplier extraDilation, float red, float green, float blue) {
        entity.supportingBlockPos.ifPresent(pos -> {
            double j = extraDilation.getAsDouble();
            BlockPos blockPos = entity.getSteppingPos();
            this.renderBlockHighlight(blockPos, matrices, cameraX, cameraY, cameraZ, vertexConsumers, 0.02 + j, red, green, blue);
            BlockPos blockPos2 = entity.getLandingPos();
            if (!blockPos2.equals((Object)blockPos)) {
                this.renderBlockHighlight(blockPos2, matrices, cameraX, cameraY, cameraZ, vertexConsumers, 0.04 + j, 0.0f, 1.0f, 1.0f);
            }
        });
    }

    private double getAdditionalDilation(Entity entity) {
        return 0.02 * (double)(String.valueOf((double)entity.getId() + 0.132453657).hashCode() % 1000) / 1000.0;
    }

    private void renderBlockHighlight(BlockPos pos, MatrixStack matrices, double cameraX, double cameraY, double cameraZ, VertexConsumerProvider vertexConsumers, double dilation, float red, float green, float blue) {
        double d = (double)pos.getX() - cameraX - 2.0 * dilation;
        double e = (double)pos.getY() - cameraY - 2.0 * dilation;
        double f = (double)pos.getZ() - cameraZ - 2.0 * dilation;
        double g = d + 1.0 + 4.0 * dilation;
        double h = e + 1.0 + 4.0 * dilation;
        double i = f + 1.0 + 4.0 * dilation;
        WorldRenderer.drawBox(matrices, vertexConsumers.getBuffer(RenderLayer.getLines()), d, e, f, g, h, i, red, green, blue, 0.4f);
        WorldRenderer.drawShapeOutline(matrices, vertexConsumers.getBuffer(RenderLayer.getLines()), this.client.world.getBlockState(pos).getCollisionShape((BlockView)this.client.world, pos, ShapeContext.absent()).offset((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), -cameraX, -cameraY, -cameraZ, red, green, blue, 1.0f, false);
    }
}

