/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.realms.gui.screen;

import com.mojang.logging.LogUtils;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.realms.RealmsClient;
import net.minecraft.client.realms.dto.RealmsServer;
import net.minecraft.client.realms.exception.RealmsServiceException;
import net.minecraft.client.realms.gui.screen.RealmsLongRunningMcoTaskScreen;
import net.minecraft.client.realms.gui.screen.RealmsMainScreen;
import net.minecraft.client.realms.gui.screen.RealmsScreen;
import net.minecraft.client.realms.task.RealmsGetServerDetailsTask;
import net.minecraft.screen.ScreenTexts;
import net.minecraft.text.StringVisitable;
import net.minecraft.text.Style;
import net.minecraft.text.Text;
import net.minecraft.util.Util;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class RealmsTermsScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Text TITLE = Text.translatable((String)"mco.terms.title");
    private static final Text SENTENCE_ONE_TEXT = Text.translatable((String)"mco.terms.sentence.1");
    private static final Text SENTENCE_TWO_TEXT = ScreenTexts.space().append((Text)Text.translatable((String)"mco.terms.sentence.2").fillStyle(Style.EMPTY.withUnderline(Boolean.valueOf(true))));
    private final Screen parent;
    private final RealmsMainScreen mainScreen;
    private final RealmsServer realmsServer;
    private boolean onLink;

    public RealmsTermsScreen(Screen parent, RealmsMainScreen mainScreen, RealmsServer realmsServer) {
        super(TITLE);
        this.parent = parent;
        this.mainScreen = mainScreen;
        this.realmsServer = realmsServer;
    }

    @Override
    public void init() {
        int i = this.width / 4 - 2;
        this.addDrawableChild(ButtonWidget.builder((Text)Text.translatable((String)"mco.terms.buttons.agree"), button -> this.agreedToTos()).dimensions(this.width / 4, RealmsTermsScreen.row(12), i, 20).build());
        this.addDrawableChild(ButtonWidget.builder((Text)Text.translatable((String)"mco.terms.buttons.disagree"), button -> this.client.setScreen(this.parent)).dimensions(this.width / 2 + 4, RealmsTermsScreen.row(12), i, 20).build());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.client.setScreen(this.parent);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void agreedToTos() {
        RealmsClient realmsClient = RealmsClient.create();
        try {
            realmsClient.agreeToTos();
            this.client.setScreen(new RealmsLongRunningMcoTaskScreen(this.parent, new RealmsGetServerDetailsTask(this.mainScreen, this.parent, this.realmsServer, new ReentrantLock())));
        }
        catch (RealmsServiceException realmsServiceException) {
            LOGGER.error("Couldn't agree to TOS");
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.onLink) {
            this.client.keyboard.setClipboard("https://aka.ms/MinecraftRealmsTerms");
            Util.getOperatingSystem().open("https://aka.ms/MinecraftRealmsTerms");
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public Text getNarratedTitle() {
        return ScreenTexts.joinSentences((Text[])new Text[]{super.getNarratedTitle(), SENTENCE_ONE_TEXT}).append(ScreenTexts.SPACE).append(SENTENCE_TWO_TEXT);
    }

    @Override
    public void render(DrawContext context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context);
        context.drawCenteredTextWithShadow(this.textRenderer, this.title, this.width / 2, 17, 0xFFFFFF);
        context.drawText(this.textRenderer, SENTENCE_ONE_TEXT, this.width / 2 - 120, RealmsTermsScreen.row(5), 0xFFFFFF, false);
        int i = this.textRenderer.getWidth((StringVisitable)SENTENCE_ONE_TEXT);
        int j = this.width / 2 - 121 + i;
        int k = RealmsTermsScreen.row(5);
        int l = j + this.textRenderer.getWidth((StringVisitable)SENTENCE_TWO_TEXT) + 1;
        int m = k + 1 + this.textRenderer.fontHeight;
        this.onLink = j <= mouseX && mouseX <= l && k <= mouseY && mouseY <= m;
        context.drawText(this.textRenderer, SENTENCE_TWO_TEXT, this.width / 2 - 120 + i, RealmsTermsScreen.row(5), this.onLink ? 7107012 : 0x3366BB, false);
        super.render(context, mouseX, mouseY, delta);
    }
}

