/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.font.MultilineText;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.screen.ScreenTexts;
import net.minecraft.text.StringVisitable;
import net.minecraft.text.Text;
import net.minecraft.util.math.MathHelper;

@Environment(value=EnvType.CLIENT)
public class NoticeScreen
extends Screen {
    private static final int NOTICE_TEXT_Y = 90;
    private final Text notice;
    private MultilineText noticeLines = MultilineText.EMPTY;
    private final Runnable actionHandler;
    private final Text buttonText;
    private final boolean shouldCloseOnEsc;

    public NoticeScreen(Runnable actionHandler, Text title, Text notice) {
        this(actionHandler, title, notice, ScreenTexts.BACK, true);
    }

    public NoticeScreen(Runnable actionHandler, Text title, Text notice, Text buttonText, boolean shouldCloseOnEsc) {
        super(title);
        this.actionHandler = actionHandler;
        this.notice = notice;
        this.buttonText = buttonText;
        this.shouldCloseOnEsc = shouldCloseOnEsc;
    }

    @Override
    public Text getNarratedTitle() {
        return ScreenTexts.joinSentences((Text[])new Text[]{super.getNarratedTitle(), this.notice});
    }

    @Override
    protected void init() {
        super.init();
        this.noticeLines = MultilineText.create(this.textRenderer, (StringVisitable)this.notice, this.width - 50);
        int i = this.noticeLines.count() * this.textRenderer.fontHeight;
        int j = MathHelper.clamp((int)(90 + i + 12), (int)(this.height / 6 + 96), (int)(this.height - 24));
        int k = 150;
        this.addDrawableChild(ButtonWidget.builder(this.buttonText, button -> this.actionHandler.run()).dimensions((this.width - 150) / 2, j, 150, 20).build());
    }

    @Override
    public void render(DrawContext context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context);
        context.drawCenteredTextWithShadow(this.textRenderer, this.title, this.width / 2, 70, 0xFFFFFF);
        this.noticeLines.drawCenterWithShadow(context, this.width / 2, 90);
        super.render(context, mouseX, mouseY, delta);
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return this.shouldCloseOnEsc;
    }
}

