/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.font.MultilineText;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.option.GameOptions;
import net.minecraft.text.StringVisitable;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.util.Util;

@Environment(value=EnvType.CLIENT)
public class DemoScreen
extends Screen {
    private static final Identifier DEMO_BG = new Identifier("textures/gui/demo_background.png");
    private MultilineText movementText = MultilineText.EMPTY;
    private MultilineText fullWrappedText = MultilineText.EMPTY;

    public DemoScreen() {
        super((Text)Text.translatable((String)"demo.help.title"));
    }

    @Override
    protected void init() {
        int i = -16;
        this.addDrawableChild(ButtonWidget.builder((Text)Text.translatable((String)"demo.help.buy"), button -> {
            button.active = false;
            Util.getOperatingSystem().open("https://aka.ms/BuyMinecraftJava");
        }).dimensions(this.width / 2 - 116, this.height / 2 + 62 + -16, 114, 20).build());
        this.addDrawableChild(ButtonWidget.builder((Text)Text.translatable((String)"demo.help.later"), button -> {
            this.client.setScreen(null);
            this.client.mouse.lockCursor();
        }).dimensions(this.width / 2 + 2, this.height / 2 + 62 + -16, 114, 20).build());
        GameOptions gameOptions = this.client.options;
        this.movementText = MultilineText.create(this.textRenderer, new Text[]{Text.translatable((String)"demo.help.movementShort", (Object[])new Object[]{gameOptions.forwardKey.getBoundKeyLocalizedText(), gameOptions.leftKey.getBoundKeyLocalizedText(), gameOptions.backKey.getBoundKeyLocalizedText(), gameOptions.rightKey.getBoundKeyLocalizedText()}), Text.translatable((String)"demo.help.movementMouse"), Text.translatable((String)"demo.help.jump", (Object[])new Object[]{gameOptions.jumpKey.getBoundKeyLocalizedText()}), Text.translatable((String)"demo.help.inventory", (Object[])new Object[]{gameOptions.inventoryKey.getBoundKeyLocalizedText()})});
        this.fullWrappedText = MultilineText.create(this.textRenderer, (StringVisitable)Text.translatable((String)"demo.help.fullWrapped"), 218);
    }

    @Override
    public void renderBackground(DrawContext context) {
        super.renderBackground(context);
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        context.drawTexture(DEMO_BG, i, j, 0, 0, 248, 166);
    }

    @Override
    public void render(DrawContext context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        context.drawText(this.textRenderer, this.title, i, j, 0x1F1F1F, false);
        j = this.movementText.draw(context, i, j + 12, 12, 0x4F4F4F);
        this.fullWrappedText.draw(context, i, j + 20, this.textRenderer.fontHeight, 0x1F1F1F);
        super.render(context, mouseX, mouseY, delta);
    }
}

