/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientSync;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class CustomIngredientImpl
extends Ingredient {
    public static final String TYPE_KEY = "fabric:type";
    public static final int PACKET_MARKER = -1;
    static final Map<Identifier, CustomIngredientSerializer<?>> REGISTERED_SERIALIZERS = new ConcurrentHashMap();
    private final CustomIngredient customIngredient;

    public static void registerSerializer(CustomIngredientSerializer<?> serializer) {
        Objects.requireNonNull(serializer.getIdentifier(), "CustomIngredientSerializer identifier may not be null.");
        if (REGISTERED_SERIALIZERS.putIfAbsent(serializer.getIdentifier(), serializer) != null) {
            throw new IllegalArgumentException("CustomIngredientSerializer with identifier " + String.valueOf(serializer.getIdentifier()) + " already registered.");
        }
    }

    @Nullable
    public static CustomIngredientSerializer<?> getSerializer(Identifier identifier) {
        Objects.requireNonNull(identifier, "Identifier may not be null.");
        return REGISTERED_SERIALIZERS.get(identifier);
    }

    public CustomIngredientImpl(CustomIngredient customIngredient) {
        super(Stream.empty());
        this.customIngredient = customIngredient;
    }

    public CustomIngredient getCustomIngredient() {
        return this.customIngredient;
    }

    public boolean requiresTesting() {
        return this.customIngredient.requiresTesting();
    }

    public ItemStack[] getMatchingStacks() {
        if (this.matchingStacks == null) {
            this.matchingStacks = (ItemStack[])this.customIngredient.getMatchingStacks().toArray(ItemStack[]::new);
        }
        return this.matchingStacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.customIngredient.test(stack);
    }

    public void write(PacketByteBuf buf) {
        Set<Identifier> supportedIngredients = CustomIngredientSync.CURRENT_SUPPORTED_INGREDIENTS.get();
        if (supportedIngredients != null && !supportedIngredients.contains(this.customIngredient.getSerializer().getIdentifier())) {
            super.write(buf);
        } else {
            buf.writeVarInt(-1);
            buf.writeIdentifier(this.customIngredient.getSerializer().getIdentifier());
            this.customIngredient.getSerializer().write(buf, (CustomIngredient)this.coerceIngredient());
        }
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(TYPE_KEY, this.customIngredient.getSerializer().getIdentifier().toString());
        this.customIngredient.getSerializer().write(json, (CustomIngredient)this.coerceIngredient());
        return json;
    }

    public boolean isEmpty() {
        return this.matchingStacks != null && this.matchingStacks.length == 0;
    }

    private <T> T coerceIngredient() {
        return (T)this.customIngredient;
    }
}

