/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.recipe.v1.ingredient;

import java.util.Objects;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.AllIngredient;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.AnyIngredient;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.DifferenceIngredient;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.NbtIngredient;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.recipe.Ingredient;
import org.jetbrains.annotations.Nullable;

public final class DefaultCustomIngredients {
    public static Ingredient all(Ingredient ... ingredients) {
        for (Ingredient ing : ingredients) {
            Objects.requireNonNull(ing, "Ingredient cannot be null");
        }
        return new AllIngredient(ingredients).toVanilla();
    }

    public static Ingredient any(Ingredient ... ingredients) {
        for (Ingredient ing : ingredients) {
            Objects.requireNonNull(ing, "Ingredient cannot be null");
        }
        return new AnyIngredient(ingredients).toVanilla();
    }

    public static Ingredient difference(Ingredient base, Ingredient subtracted) {
        Objects.requireNonNull(base, "Base ingredient cannot be null");
        Objects.requireNonNull(subtracted, "Subtracted ingredient cannot be null");
        return new DifferenceIngredient(base, subtracted).toVanilla();
    }

    public static Ingredient nbt(Ingredient base, @Nullable NbtCompound nbt, boolean strict) {
        Objects.requireNonNull(base, "Base ingredient cannot be null");
        return new NbtIngredient(base, nbt, strict).toVanilla();
    }

    public static Ingredient nbt(ItemStack stack, boolean strict) {
        Objects.requireNonNull(stack, "Stack cannot be null");
        return DefaultCustomIngredients.nbt(Ingredient.ofItems((ItemConvertible[])new ItemConvertible[]{stack.getItem()}), stack.getNbt(), strict);
    }

    private DefaultCustomIngredients() {
    }
}

