/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.interaction.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockApplyCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.mixin.event.interaction.client.KeyBindingAccessor;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.client.network.ClientPlayerInteractionManager;
import net.minecraft.client.option.GameOptions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.PlayerInteractEntityC2SPacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.hit.EntityHitResult;
import net.minecraft.util.hit.HitResult;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MinecraftClient.class})
public abstract class MinecraftClientMixin {
    private boolean fabric_itemPickCancelled;
    private boolean fabric_attackCancelled;
    @Shadow
    private ClientPlayerEntity field_1724;
    @Shadow
    @Final
    public GameOptions field_1690;
    @Shadow
    @Nullable
    public ClientPlayerInteractionManager field_1761;

    private ItemStack fabric_emulateOldPick() {
        MinecraftClient client = (MinecraftClient)this;
        ClientPickBlockCallback.Container ctr = new ClientPickBlockCallback.Container(ItemStack.EMPTY);
        ((ClientPickBlockCallback)ClientPickBlockCallback.EVENT.invoker()).pick((PlayerEntity)client.player, client.crosshairTarget, ctr);
        return ctr.getStack();
    }

    @Inject(at={@At(value="HEAD")}, method={"doItemPick"}, cancellable=true)
    private void fabric_doItemPickWrapper(CallbackInfo info) {
        MinecraftClient client = (MinecraftClient)this;
        ItemStack stack = ((ClientPickBlockGatherCallback)ClientPickBlockGatherCallback.EVENT.invoker()).pick((PlayerEntity)client.player, client.crosshairTarget);
        if (stack.isEmpty()) {
            stack = this.fabric_emulateOldPick();
        }
        if (!stack.isEmpty()) {
            BlockEntity be;
            info.cancel();
            PlayerInventory playerInventory = client.player.getInventory();
            if (client.player.getAbilities().creativeMode && Screen.hasControlDown() && client.crosshairTarget.getType() == HitResult.Type.BLOCK && (be = client.world.getBlockEntity(((BlockHitResult)client.crosshairTarget).getBlockPos())) != null) {
                this.method_1499(stack, be);
            }
            if ((stack = ((ClientPickBlockApplyCallback)ClientPickBlockApplyCallback.EVENT.invoker()).pick((PlayerEntity)client.player, client.crosshairTarget, stack)).isEmpty()) {
                return;
            }
            if (client.player.getAbilities().creativeMode) {
                playerInventory.addPickBlock(stack);
                client.interactionManager.clickCreativeStack(client.player.getStackInHand(Hand.MAIN_HAND), 36 + playerInventory.selectedSlot);
            } else {
                int slot = playerInventory.getSlotWithStack(stack);
                if (slot >= 0) {
                    if (PlayerInventory.isValidHotbarIndex((int)slot)) {
                        playerInventory.selectedSlot = slot;
                    } else {
                        client.interactionManager.pickFromInventory(slot);
                    }
                }
            }
        }
    }

    @Shadow
    protected abstract void method_1499(ItemStack var1, BlockEntity var2);

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;getSlotWithStack(Lnet/minecraft/item/ItemStack;)I", shift=At.Shift.BEFORE), method={"doItemPick"}, ordinal=0)
    public ItemStack modifyItemPick(ItemStack stack) {
        MinecraftClient client = (MinecraftClient)this;
        ItemStack result = ((ClientPickBlockApplyCallback)ClientPickBlockApplyCallback.EVENT.invoker()).pick((PlayerEntity)client.player, client.crosshairTarget, stack);
        this.fabric_itemPickCancelled = result.isEmpty();
        return result;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;getSlotWithStack(Lnet/minecraft/item/ItemStack;)I")}, method={"doItemPick"}, cancellable=true)
    public void cancelItemPick(CallbackInfo info) {
        if (this.fabric_itemPickCancelled) {
            info.cancel();
        }
    }

    @Shadow
    public abstract ClientPlayNetworkHandler method_1562();

    @Inject(at={@At(value="INVOKE", target="net/minecraft/client/network/ClientPlayerInteractionManager.interactEntityAtLocation(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/hit/EntityHitResult;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;")}, method={"doItemUse"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectUseEntityCallback(CallbackInfo ci, Hand[] hands, int i1, int i2, Hand hand, ItemStack stack, EntityHitResult hitResult, Entity entity) {
        ActionResult result = ((UseEntityCallback)UseEntityCallback.EVENT.invoker()).interact((PlayerEntity)this.field_1724, this.field_1724.getEntityWorld(), hand, entity, hitResult);
        if (result != ActionResult.PASS) {
            if (result.isAccepted()) {
                Vec3d hitVec = hitResult.getPos().subtract(entity.getX(), entity.getY(), entity.getZ());
                this.method_1562().sendPacket((Packet)PlayerInteractEntityC2SPacket.interactAt((Entity)entity, (boolean)this.field_1724.isSneaking(), (Hand)hand, (Vec3d)hitVec));
            }
            if (result.shouldSwingHand()) {
                this.field_1724.swingHand(hand);
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;isUsingItem()Z", ordinal=0)})
    private void injectHandleInputEventsForPreAttackCallback(CallbackInfo ci) {
        int attackKeyPressCount = ((KeyBindingAccessor)this.field_1690.attackKey).fabric_getTimesPressed();
        this.fabric_attackCancelled = this.field_1690.attackKey.isPressed() || attackKeyPressCount != 0 ? ((ClientPreAttackCallback)ClientPreAttackCallback.EVENT.invoker()).onClientPlayerPreAttack((MinecraftClient)this, this.field_1724, attackKeyPressCount) : false;
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectDoAttackForCancelling(CallbackInfoReturnable<Boolean> cir) {
        if (this.fabric_attackCancelled) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectHandleBlockBreakingForCancelling(boolean breaking, CallbackInfo ci) {
        if (this.fabric_attackCancelled) {
            if (this.field_1761 != null) {
                this.field_1761.cancelBlockBreaking();
            }
            ci.cancel();
        }
    }
}

