/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup.client;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.itemgroup.CreativeGuiExtensions;
import net.fabricmc.fabric.impl.client.itemgroup.FabricCreativeGuiComponents;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.screen.ingame.AbstractInventoryScreen;
import net.minecraft.client.gui.screen.ingame.CreativeInventoryScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemGroups;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.text.Text;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={CreativeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin<T extends ScreenHandler>
extends AbstractInventoryScreen<T>
implements CreativeGuiExtensions {
    @Shadow
    private static ItemGroup field_2896;
    private static int fabric_currentPage;

    public CreativeInventoryScreenMixin(T screenHandler, PlayerInventory playerInventory, Text text) {
        super(screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void method_2466(ItemGroup var1);

    @Override
    public void fabric_nextPage() {
        if (!CreativeInventoryScreenMixin.fabric_hasGroupForPage(fabric_currentPage + 1)) {
            return;
        }
        ++fabric_currentPage;
        this.fabric_updateSelection();
    }

    @Override
    public void fabric_previousPage() {
        if (fabric_currentPage == 0) {
            return;
        }
        --fabric_currentPage;
        this.fabric_updateSelection();
    }

    @Override
    public boolean fabric_isButtonVisible(FabricCreativeGuiComponents.Type type) {
        return ItemGroups.getGroupsToDisplay().size() > (Objects.requireNonNull(ItemGroups.displayContext).hasPermissions() ? 14 : 13);
    }

    @Override
    public boolean fabric_isButtonEnabled(FabricCreativeGuiComponents.Type type) {
        if (type == FabricCreativeGuiComponents.Type.NEXT) {
            return CreativeInventoryScreenMixin.fabric_hasGroupForPage(fabric_currentPage + 1);
        }
        if (type == FabricCreativeGuiComponents.Type.PREVIOUS) {
            return fabric_currentPage != 0;
        }
        return false;
    }

    private void fabric_updateSelection() {
        if (!this.fabric_isGroupVisible(field_2896)) {
            ItemGroups.getGroups().stream().filter(this::fabric_isGroupVisible).min((a, b) -> {
                if (a.isSpecial() && !b.isSpecial()) {
                    return 1;
                }
                if (!a.isSpecial() && b.isSpecial()) {
                    return -1;
                }
                return 0;
            }).ifPresent(this::method_2466);
        }
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo info) {
        fabric_currentPage = CreativeInventoryScreenMixin.fabric_getPage(field_2896);
        int xpos = this.x + 170;
        int ypos = this.y + 4;
        this.addDrawableChild((Element)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 11, ypos, FabricCreativeGuiComponents.Type.NEXT, this));
        this.addDrawableChild((Element)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(ItemGroup itemGroup, CallbackInfo info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"renderTabTooltipIfHovered"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(DrawContext drawContext, ItemGroup itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isClickInTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(ItemGroup itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(DrawContext drawContext, ItemGroup itemGroup, CallbackInfo info) {
        if (!this.fabric_isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    private boolean fabric_isGroupVisible(ItemGroup itemGroup) {
        return fabric_currentPage == CreativeInventoryScreenMixin.fabric_getPage(itemGroup);
    }

    private static int fabric_getPage(ItemGroup itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return fabric_currentPage;
        }
        FabricItemGroup fabricItemGroup = (FabricItemGroup)itemGroup;
        return fabricItemGroup.getPage();
    }

    private static boolean fabric_hasGroupForPage(int page) {
        return ItemGroups.getGroupsToDisplay().stream().anyMatch(itemGroup -> CreativeInventoryScreenMixin.fabric_getPage(itemGroup) == page);
    }

    @Override
    public int fabric_currentPage() {
        return fabric_currentPage;
    }

    static {
        fabric_currentPage = 0;
    }
}

