/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.data.DataProvider;
import net.minecraft.registry.BuiltinRegistries;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.Registerable;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryBuilder;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.util.Util;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricDataGenHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricDataGenHelper.class);
    public static final boolean ENABLED = System.getProperty("fabric-api.datagen") != null;
    private static final String OUTPUT_DIR = System.getProperty("fabric-api.datagen.output-dir");
    private static final boolean STRICT_VALIDATION = System.getProperty("fabric-api.datagen.strict-validation") != null;
    @Nullable
    private static final String MOD_ID_FILTER = System.getProperty("fabric-api.datagen.modid");
    private static final String ENTRYPOINT_KEY = "fabric-datagen";
    private static final Map<Object, ConditionJsonProvider[]> CONDITIONS_MAP = new IdentityHashMap<Object, ConditionJsonProvider[]>();

    private FabricDataGenHelper() {
    }

    public static void run() {
        try {
            FabricDataGenHelper.runInternal();
        }
        catch (Throwable t) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to run data generation", t);
            System.exit(-1);
        }
    }

    private static void runInternal() {
        Path outputDir = Paths.get(Objects.requireNonNull(OUTPUT_DIR, "No output dir provided with the 'fabric-api.datagen.output-dir' property"), new String[0]);
        List dataGeneratorInitializers = FabricLoader.getInstance().getEntrypointContainers(ENTRYPOINT_KEY, DataGeneratorEntrypoint.class);
        if (dataGeneratorInitializers.isEmpty()) {
            LOGGER.warn("No data generator entrypoints are defined. Implement {} and add your class to the '{}' entrypoint key in your fabric.mod.json.", (Object)DataGeneratorEntrypoint.class.getName(), (Object)ENTRYPOINT_KEY);
        }
        List<DataGeneratorEntrypoint> entrypoints = dataGeneratorInitializers.stream().map(EntrypointContainer::getEntrypoint).toList();
        CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture = CompletableFuture.supplyAsync(() -> FabricDataGenHelper.createRegistryWrapper(entrypoints), Util.getMainWorkerExecutor());
        Object2IntOpenHashMap jsonKeySortOrders = (Object2IntOpenHashMap)DataProvider.JSON_KEY_SORT_ORDER;
        Object2IntOpenHashMap defaultJsonKeySortOrders = new Object2IntOpenHashMap((Object2IntMap)jsonKeySortOrders);
        for (EntrypointContainer entrypointContainer : dataGeneratorInitializers) {
            String id = entrypointContainer.getProvider().getMetadata().getId();
            if (MOD_ID_FILTER != null && !id.equals(MOD_ID_FILTER)) continue;
            LOGGER.info("Running data generator for {}", (Object)id);
            try {
                DataGeneratorEntrypoint entrypoint = (DataGeneratorEntrypoint)entrypointContainer.getEntrypoint();
                String effectiveModId = entrypoint.getEffectiveModId();
                ModContainer modContainer = entrypointContainer.getProvider();
                HashSet keys = new HashSet();
                entrypoint.addJsonKeySortOrders((key, value) -> {
                    Objects.requireNonNull(key, "Tried to register a priority for a null key");
                    jsonKeySortOrders.put((Object)key, value);
                    keys.add(key);
                });
                if (effectiveModId != null) {
                    modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(effectiveModId).orElseThrow(() -> new RuntimeException("Failed to find effective mod container for mod id (%s)".formatted(effectiveModId)));
                }
                FabricDataGenerator dataGenerator = new FabricDataGenerator(outputDir, modContainer, STRICT_VALIDATION, registriesFuture);
                entrypoint.onInitializeDataGenerator(dataGenerator);
                dataGenerator.run();
                jsonKeySortOrders.keySet().removeAll(keys);
                jsonKeySortOrders.putAll((Map)defaultJsonKeySortOrders);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to run data generator from mod (%s)".formatted(id), t);
            }
        }
    }

    private static RegistryWrapper.WrapperLookup createRegistryWrapper(List<DataGeneratorEntrypoint> dataGeneratorInitializers) {
        ArrayList<RegistryBuilder> builders = new ArrayList<RegistryBuilder>();
        builders.add(BuiltinRegistries.REGISTRY_BUILDER);
        for (DataGeneratorEntrypoint dataGeneratorEntrypoint : dataGeneratorInitializers) {
            RegistryBuilder registryBuilder = new RegistryBuilder();
            dataGeneratorEntrypoint.buildRegistry(registryBuilder);
            builders.add(registryBuilder);
        }
        class BuilderData {
            final RegistryKey key;
            List<RegistryBuilder.BootstrapFunction<?>> bootstrapFunctions;
            Lifecycle lifecycle;

            BuilderData(RegistryKey key) {
                this.key = key;
                this.bootstrapFunctions = new ArrayList();
                this.lifecycle = null;
            }

            void with(RegistryBuilder.RegistryInfo<?> registryInfo) {
                this.bootstrapFunctions.add(registryInfo.bootstrap());
                this.lifecycle = registryInfo.lifecycle().add(this.lifecycle);
            }

            void apply(RegistryBuilder builder) {
                builder.addRegistry(this.key, this.lifecycle, this::bootstrap);
            }

            void bootstrap(Registerable registerable) {
                for (RegistryBuilder.BootstrapFunction<?> function : this.bootstrapFunctions) {
                    function.run(registerable);
                }
            }
        }
        HashMap<RegistryKey, BuilderData> builderDataMap = new HashMap<RegistryKey, BuilderData>();
        for (RegistryBuilder registryBuilder : builders) {
            for (RegistryBuilder.RegistryInfo info : registryBuilder.registries) {
                builderDataMap.computeIfAbsent(info.key(), x$0 -> new BuilderData((RegistryKey)x$0)).with(info);
            }
        }
        RegistryBuilder registryBuilder = new RegistryBuilder();
        for (BuilderData value : builderDataMap.values()) {
            value.apply(registryBuilder);
        }
        RegistryWrapper.WrapperLookup wrapperLookup = registryBuilder.createWrapperLookup((DynamicRegistryManager)DynamicRegistryManager.of((Registry)Registries.REGISTRIES));
        BuiltinRegistries.validate((RegistryWrapper.WrapperLookup)wrapperLookup);
        return wrapperLookup;
    }

    public static void addConditions(Object object, ConditionJsonProvider[] conditions) {
        CONDITIONS_MAP.merge(object, conditions, ArrayUtils::addAll);
    }

    @Nullable
    public static ConditionJsonProvider[] consumeConditions(Object object) {
        return CONDITIONS_MAP.remove(object);
    }
}

