/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader;

import java.io.InputStream;
import java.util.List;
import net.fabricmc.fabric.impl.resource.loader.GroupResourcePack;
import net.minecraft.resource.InputSupplier;
import net.minecraft.resource.NamespaceResourceManager;
import net.minecraft.resource.Resource;
import net.minecraft.resource.ResourcePack;
import net.minecraft.resource.ResourceType;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={NamespaceResourceManager.class})
public class NamespaceResourceManagerMixin {
    private final ThreadLocal<List<Resource>> fabric$getAllResources$resources = new ThreadLocal();

    @Inject(method={"getAllResources"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onGetAllResources(Identifier id, CallbackInfoReturnable<List<Resource>> cir, Identifier metadataId, List<Resource> resources) {
        this.fabric$getAllResources$resources.set(resources);
    }

    @Redirect(method={"getAllResources"}, at=@At(value="INVOKE", target="Lnet/minecraft/resource/ResourcePack;open(Lnet/minecraft/resource/ResourceType;Lnet/minecraft/util/Identifier;)Lnet/minecraft/resource/InputSupplier;"))
    private InputSupplier<InputStream> onResourceAdd(ResourcePack pack, ResourceType type, Identifier id) {
        if (pack instanceof GroupResourcePack) {
            ((GroupResourcePack)pack).appendResources(type, id, this.fabric$getAllResources$resources.get());
            return null;
        }
        return pack.open(type, id);
    }
}

