/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.resource.ResourcePack;
import net.minecraft.resource.ResourcePackProfile;
import net.minecraft.resource.ResourcePackSource;
import net.minecraft.resource.ResourceReloader;
import net.minecraft.resource.ResourceType;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<ResourceType, ResourceManagerHelperImpl> registryMap = new HashMap<ResourceType, ResourceManagerHelperImpl>();
    private static final Set<Pair<Text, ModNioResourcePack>> builtinResourcePacks = new HashSet<Pair<Text, ModNioResourcePack>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManagerHelperImpl.class);
    private final Set<Identifier> addedListenerIds = new HashSet<Identifier>();
    private final Set<IdentifiableResourceReloadListener> addedListeners = new LinkedHashSet<IdentifiableResourceReloadListener>();

    public static ResourceManagerHelperImpl get(ResourceType type) {
        return registryMap.computeIfAbsent(type, t -> new ResourceManagerHelperImpl());
    }

    public static boolean registerBuiltinResourcePack(Identifier id, String subPath, ModContainer container, Text displayName, ResourcePackActivationType activationType) {
        List paths = container.getRootPaths();
        String separator = ((Path)paths.get(0)).getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        ModNioResourcePack resourcePack = ModNioResourcePack.create(id.toString(), container, subPath, ResourceType.CLIENT_RESOURCES, activationType);
        ModNioResourcePack dataPack = ModNioResourcePack.create(id.toString(), container, subPath, ResourceType.SERVER_DATA, activationType);
        if (resourcePack == null && dataPack == null) {
            return false;
        }
        if (resourcePack != null) {
            builtinResourcePacks.add((Pair<Text, ModNioResourcePack>)new Pair((Object)displayName, (Object)resourcePack));
        }
        if (dataPack != null) {
            builtinResourcePacks.add((Pair<Text, ModNioResourcePack>)new Pair((Object)displayName, (Object)dataPack));
        }
        return true;
    }

    public static boolean registerBuiltinResourcePack(Identifier id, String subPath, ModContainer container, ResourcePackActivationType activationType) {
        return ResourceManagerHelperImpl.registerBuiltinResourcePack(id, subPath, container, (Text)Text.literal((String)(id.getNamespace() + "/" + id.getPath())), activationType);
    }

    public static void registerBuiltinResourcePacks(ResourceType resourceType, Consumer<ResourcePackProfile> consumer) {
        for (Pair<Text, ModNioResourcePack> entry : builtinResourcePacks) {
            ModNioResourcePack pack = (ModNioResourcePack)entry.getRight();
            if (pack.getNamespaces(resourceType).isEmpty()) continue;
            ResourcePackProfile profile = ResourcePackProfile.create((String)((ModNioResourcePack)entry.getRight()).getName(), (Text)((Text)entry.getLeft()), (pack.getActivationType() == ResourcePackActivationType.ALWAYS_ENABLED ? 1 : 0) != 0, ignored -> (ResourcePack)entry.getRight(), (ResourceType)resourceType, (ResourcePackProfile.InsertionPosition)ResourcePackProfile.InsertionPosition.TOP, (ResourcePackSource)new BuiltinModResourcePackSource(pack.getFabricModMetadata().getName()));
            consumer.accept(profile);
        }
    }

    public static List<ResourceReloader> sort(ResourceType type, List<ResourceReloader> listeners) {
        if (type == null) {
            return listeners;
        }
        ResourceManagerHelperImpl instance = ResourceManagerHelperImpl.get(type);
        if (instance != null) {
            ArrayList<ResourceReloader> mutable = new ArrayList<ResourceReloader>(listeners);
            instance.sort(mutable);
            return Collections.unmodifiableList(mutable);
        }
        return listeners;
    }

    protected void sort(List<ResourceReloader> listeners) {
        listeners.removeAll(this.addedListeners);
        ArrayList listenersToAdd = Lists.newArrayList(this.addedListeners);
        HashSet<Identifier> resolvedIds = new HashSet<Identifier>();
        for (ResourceReloader listener : listeners) {
            if (!(listener instanceof IdentifiableResourceReloadListener)) continue;
            resolvedIds.add(((IdentifiableResourceReloadListener)listener).getFabricId());
        }
        int lastSize = -1;
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                IdentifiableResourceReloadListener listener = (IdentifiableResourceReloadListener)it.next();
                if (!resolvedIds.containsAll(listener.getFabricDependencies())) continue;
                resolvedIds.add(listener.getFabricId());
                listeners.add(listener);
                it.remove();
            }
        }
        for (IdentifiableResourceReloadListener listener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + String.valueOf(listener.getFabricId()) + "!");
        }
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        if (!this.addedListenerIds.add(listener.getFabricId())) {
            LOGGER.warn("Tried to register resource reload listener " + String.valueOf(listener.getFabricId()) + " twice!");
            return;
        }
        if (!this.addedListeners.add(listener)) {
            throw new RuntimeException("Listener with previously unknown ID " + String.valueOf(listener.getFabricId()) + " already in listener set!");
        }
    }
}

