/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.GroupResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.SharedConstants;
import net.minecraft.resource.AbstractFileResourcePack;
import net.minecraft.resource.InputSupplier;
import net.minecraft.resource.ResourceType;
import net.minecraft.resource.metadata.ResourceMetadataReader;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class FabricModResourcePack
extends GroupResourcePack {
    public FabricModResourcePack(ResourceType type, List<ModResourcePack> packs) {
        super(type, packs);
    }

    public InputSupplier<InputStream> openRoot(String ... pathSegments) {
        String fileName = String.join((CharSequence)"/", pathSegments);
        if ("pack.mcmeta".equals(fileName)) {
            String description = "pack.description.modResources";
            String fallback = "Mod resources.";
            String pack = String.format("{\"pack\":{\"pack_format\":" + SharedConstants.getGameVersion().getResourceVersion(this.type) + ",\"description\":{\"translate\":\"%s\",\"fallback\":\"%s.\"}}}", description, fallback);
            return () -> IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
        }
        if ("pack.png".equals(fileName)) {
            return FabricLoader.getInstance().getModContainer("fabric-resource-loader-v0").flatMap(container -> container.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)container).findPath(arg_0))).map(path -> () -> Files.newInputStream(path, new OpenOption[0])).orElse(null);
        }
        return null;
    }

    @Nullable
    public <T> T parseMetadata(ResourceMetadataReader<T> metaReader) throws IOException {
        InputSupplier<InputStream> inputSupplier = this.openRoot("pack.mcmeta");
        if (inputSupplier != null) {
            try (InputStream input = (InputStream)inputSupplier.get();){
                Object object = AbstractFileResourcePack.parseMetadata(metaReader, (InputStream)input);
                return (T)object;
            }
        }
        return null;
    }

    public String getName() {
        return "fabric";
    }

    public boolean isAlwaysStable() {
        return true;
    }
}

