/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.entity.event;

import com.mojang.datafixers.util.Either;
import java.util.List;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.mixin.entity.event.LivingEntityMixin;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.damage.DamageSource;
import net.minecraft.entity.mob.HostileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.registry.RegistryKey;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.state.property.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayerEntity.class})
abstract class ServerPlayerEntityMixin
extends LivingEntityMixin {
    ServerPlayerEntityMixin() {
    }

    @Shadow
    public abstract ServerWorld method_51469();

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;getPrimeAdversary()Lnet/minecraft/entity/LivingEntity;")})
    private void callOnKillForPlayer(DamageSource source, CallbackInfo ci) {
        Entity attacker = source.getAttacker();
        if (attacker != null) {
            attacker.onKilledOther(this.method_51469(), (LivingEntity)((ServerPlayerEntity)this));
            ((ServerEntityCombatEvents.AfterKilledOtherEntity)ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.invoker()).afterKilledOtherEntity(this.method_51469(), attacker, (LivingEntity)((ServerPlayerEntity)this));
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="TAIL")})
    private void notifyDeath(DamageSource source, CallbackInfo ci) {
        ((ServerLivingEntityEvents.AfterDeath)ServerLivingEntityEvents.AFTER_DEATH.invoker()).afterDeath((LivingEntity)((ServerPlayerEntity)this), source);
    }

    @Inject(method={"worldChanged(Lnet/minecraft/server/world/ServerWorld;)V"}, at={@At(value="TAIL")})
    private void afterWorldChanged(ServerWorld origin, CallbackInfo ci) {
        ((ServerEntityWorldChangeEvents.AfterPlayerChange)ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.invoker()).afterChangeWorld((ServerPlayerEntity)this, origin, this.method_51469());
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void onCopyFrom(ServerPlayerEntity oldPlayer, boolean alive, CallbackInfo ci) {
        ((ServerPlayerEvents.CopyFrom)ServerPlayerEvents.COPY_FROM.invoker()).copyFromPlayer(oldPlayer, (ServerPlayerEntity)this, alive);
    }

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;get(Lnet/minecraft/state/property/Property;)Ljava/lang/Comparable;"))
    private Comparable<?> redirectSleepDirection(BlockState state, Property<?> property, BlockPos pos) {
        Direction initial = state.contains(property) ? (Direction)state.get(property) : null;
        return ((EntitySleepEvents.ModifySleepingDirection)EntitySleepEvents.MODIFY_SLEEPING_DIRECTION.invoker()).modifySleepDirection((LivingEntity)this, pos, initial);
    }

    @Inject(method={"trySleep"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;get(Lnet/minecraft/state/property/Property;)Ljava/lang/Comparable;", shift=At.Shift.BY, by=3)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onTrySleepDirectionCheck(BlockPos pos, CallbackInfoReturnable<Either<PlayerEntity.SleepFailureReason, Unit>> info, @Nullable Direction sleepingDirection) {
        if (sleepingDirection == null) {
            info.setReturnValue((Object)Either.left((Object)PlayerEntity.SleepFailureReason.NOT_POSSIBLE_HERE));
        }
    }

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V"))
    private void onSetSpawnPoint(ServerPlayerEntity player, RegistryKey<World> dimension, BlockPos pos, float angle, boolean spawnPointSet, boolean sendMessage) {
        if (((EntitySleepEvents.AllowSettingSpawn)EntitySleepEvents.ALLOW_SETTING_SPAWN.invoker()).allowSettingSpawn((PlayerEntity)player, pos)) {
            player.setSpawnPoint(dimension, pos, angle, spawnPointSet, sendMessage);
        }
    }

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", remap=false))
    private boolean hasNoMonstersNearby(List<HostileEntity> monsters, BlockPos pos) {
        boolean vanillaResult = monsters.isEmpty();
        ActionResult result = ((EntitySleepEvents.AllowNearbyMonsters)EntitySleepEvents.ALLOW_NEARBY_MONSTERS.invoker()).allowNearbyMonsters((PlayerEntity)this, pos, vanillaResult);
        return result != ActionResult.PASS ? result.isAccepted() : vanillaResult;
    }

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isDay()Z"))
    private boolean redirectDaySleepCheck(World world, BlockPos pos) {
        boolean day = world.isDay();
        ActionResult result = ((EntitySleepEvents.AllowSleepTime)EntitySleepEvents.ALLOW_SLEEP_TIME.invoker()).allowSleepTime((PlayerEntity)this, pos, !day);
        if (result != ActionResult.PASS) {
            return !result.isAccepted();
        }
        return day;
    }
}

