/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity.event.v1;

import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class EntityElytraEvents {
    public static final Event<Allow> ALLOW = EventFactory.createArrayBacked(Allow.class, listeners -> entity -> {
        for (Allow listener : listeners) {
            if (listener.allowElytraFlight(entity)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Custom> CUSTOM = EventFactory.createArrayBacked(Custom.class, listeners -> (entity, tickElytra) -> {
        for (Custom listener : listeners) {
            if (!listener.useCustomElytra(entity, tickElytra)) continue;
            return true;
        }
        return false;
    });

    private EntityElytraEvents() {
    }

    static {
        CUSTOM.register((entity, tickElytra) -> {
            ItemStack chestStack = entity.getEquippedStack(EquipmentSlot.CHEST);
            Item patt0$temp = chestStack.getItem();
            if (patt0$temp instanceof FabricElytraItem) {
                FabricElytraItem fabricElytraItem = (FabricElytraItem)patt0$temp;
                return fabricElytraItem.useCustomElytra(entity, chestStack, tickElytra);
            }
            return false;
        });
    }

    @FunctionalInterface
    public static interface Custom {
        public boolean useCustomElytra(LivingEntity var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Allow {
        public boolean allowElytraFlight(LivingEntity var1);
    }
}

