/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.EntityRendererFactory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;

@Environment(value=EnvType.CLIENT)
public final class EntityRendererRegistryImpl {
    private static HashMap<EntityType<?>, EntityRendererFactory<?>> map = new HashMap();
    private static BiConsumer<EntityType<?>, EntityRendererFactory<?>> handler = (type, function) -> map.put((EntityType<?>)type, (EntityRendererFactory<?>)function);

    public static <T extends Entity> void register(EntityType<? extends T> entityType, EntityRendererFactory<T> factory) {
        handler.accept(entityType, factory);
    }

    public static void setup(BiConsumer<EntityType<?>, EntityRendererFactory<?>> vanillaHandler) {
        map.forEach(vanillaHandler);
        handler = vanillaHandler;
    }

    private EntityRendererRegistryImpl() {
    }
}

