/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.registry.Registries;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ArmorRendererRegistryImpl {
    private static final HashMap<Item, ArmorRenderer> RENDERERS = new HashMap();

    public static void register(ArmorRenderer renderer, ItemConvertible ... items) {
        Objects.requireNonNull(renderer, "renderer is null");
        if (items.length == 0) {
            throw new IllegalArgumentException("Armor renderer registered for no item");
        }
        for (ItemConvertible item : items) {
            Objects.requireNonNull(item.asItem(), "armor item is null");
            if (RENDERERS.putIfAbsent(item.asItem(), renderer) == null) continue;
            throw new IllegalArgumentException("Custom armor renderer already exists for " + String.valueOf(Registries.ITEM.getId((Object)item.asItem())));
        }
    }

    @Nullable
    public static ArmorRenderer get(Item item) {
        return RENDERERS.get(item);
    }
}

