/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block.type;

import net.minecraft.block.BlockSetType;
import net.minecraft.block.WoodType;
import net.minecraft.sound.BlockSoundGroup;
import net.minecraft.sound.SoundEvent;
import net.minecraft.sound.SoundEvents;
import net.minecraft.util.Identifier;

public final class WoodTypeBuilder {
    private BlockSoundGroup soundGroup = BlockSoundGroup.WOOD;
    private BlockSoundGroup hangingSignSoundGroup = BlockSoundGroup.HANGING_SIGN;
    private SoundEvent fenceGateCloseSound = SoundEvents.BLOCK_FENCE_GATE_CLOSE;
    private SoundEvent fenceGateOpenSound = SoundEvents.BLOCK_FENCE_GATE_OPEN;

    public WoodTypeBuilder soundGroup(BlockSoundGroup soundGroup) {
        this.soundGroup = soundGroup;
        return this;
    }

    public WoodTypeBuilder hangingSignSoundGroup(BlockSoundGroup hangingSignSoundGroup) {
        this.hangingSignSoundGroup = hangingSignSoundGroup;
        return this;
    }

    public WoodTypeBuilder fenceGateCloseSound(SoundEvent fenceGateCloseSound) {
        this.fenceGateCloseSound = fenceGateCloseSound;
        return this;
    }

    public WoodTypeBuilder fenceGateOpenSound(SoundEvent fenceGateOpenSound) {
        this.fenceGateOpenSound = fenceGateOpenSound;
        return this;
    }

    public static WoodTypeBuilder copyOf(WoodTypeBuilder builder) {
        WoodTypeBuilder copy = new WoodTypeBuilder();
        copy.soundGroup(builder.soundGroup);
        copy.hangingSignSoundGroup(builder.hangingSignSoundGroup);
        copy.fenceGateCloseSound(builder.fenceGateCloseSound);
        copy.fenceGateOpenSound(builder.fenceGateOpenSound);
        return copy;
    }

    public static WoodTypeBuilder copyOf(WoodType woodType) {
        WoodTypeBuilder copy = new WoodTypeBuilder();
        copy.soundGroup(woodType.soundType());
        copy.hangingSignSoundGroup(woodType.hangingSignSoundType());
        copy.fenceGateCloseSound(woodType.fenceGateClose());
        copy.fenceGateOpenSound(woodType.fenceGateOpen());
        return copy;
    }

    public WoodType register(Identifier id, BlockSetType setType) {
        return WoodType.register((WoodType)this.build(id, setType));
    }

    public WoodType build(Identifier id, BlockSetType setType) {
        return new WoodType(id.toString(), setType, this.soundGroup, this.hangingSignSoundGroup, this.fenceGateCloseSound, this.fenceGateOpenSound);
    }
}

