/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.screenhandler.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ingame.HandledScreens;
import net.minecraft.client.gui.screen.ingame.ScreenHandlerProvider;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.registry.Registries;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientNetworking
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-screen-handler-api-v1/client");

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((Identifier)Networking.OPEN_ID, (client, handler, buf, responseSender) -> {
            Identifier typeId = buf.readIdentifier();
            int syncId = buf.readVarInt();
            Text title = buf.readText();
            buf.retain();
            client.execute(() -> this.openScreen(typeId, syncId, title, buf));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openScreen(Identifier typeId, int syncId, Text title, PacketByteBuf buf) {
        try {
            ScreenHandlerType type = (ScreenHandlerType)Registries.SCREEN_HANDLER.get(typeId);
            if (type == null) {
                LOGGER.warn("Unknown screen handler ID: {}", (Object)typeId);
                return;
            }
            if (!(type instanceof ExtendedScreenHandlerType)) {
                LOGGER.warn("Received extended opening packet for non-extended screen handler {}", (Object)typeId);
                return;
            }
            HandledScreens.Provider screenFactory = HandledScreens.getProvider((ScreenHandlerType)type);
            if (screenFactory != null) {
                MinecraftClient client = MinecraftClient.getInstance();
                ClientPlayerEntity player = client.player;
                Screen screen = screenFactory.create(((ExtendedScreenHandlerType)type).create(syncId, player.getInventory(), buf), player.getInventory(), title);
                player.currentScreenHandler = ((ScreenHandlerProvider)screen).getScreenHandler();
                client.setScreen(screen);
            } else {
                LOGGER.warn("Screen not registered for screen handler {}!", (Object)typeId);
            }
        }
        finally {
            buf.release();
        }
    }
}

