/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.networking.v0;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.PacketRegistry;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.minecraft.client.MinecraftClient;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Identifier;
import net.minecraft.util.thread.ThreadExecutor;

@Environment(value=EnvType.CLIENT)
public class ClientSidePacketRegistryImpl
implements ClientSidePacketRegistry,
PacketRegistry {
    @Override
    public boolean canServerReceive(Identifier id) {
        return ClientPlayNetworking.getSendable().contains(id);
    }

    @Override
    public void sendToServer(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
        if (MinecraftClient.getInstance().getNetworkHandler() != null) {
            MinecraftClient.getInstance().getNetworkHandler().getConnection().send(packet, (PacketCallbacks)GenericFutureListenerHolder.create(completionListener));
            return;
        }
        throw new IllegalStateException("Cannot send packet to server while not in game!");
    }

    @Override
    public Packet<?> toPacket(Identifier id, PacketByteBuf buf) {
        return ClientPlayNetworking.createC2SPacket((Identifier)id, (PacketByteBuf)buf);
    }

    @Override
    public void register(Identifier id, PacketConsumer consumer) {
        Objects.requireNonNull(consumer, "PacketConsumer cannot be null");
        ClientPlayNetworking.registerGlobalReceiver((Identifier)id, (client, handler, buf, sender) -> consumer.accept(new PacketContext(){

            @Override
            public EnvType getPacketEnvironment() {
                return EnvType.CLIENT;
            }

            @Override
            public PlayerEntity getPlayer() {
                return client.player;
            }

            public ThreadExecutor<?> getTaskQueue() {
                return client;
            }
        }, buf));
    }

    @Override
    public void unregister(Identifier id) {
        ClientPlayNetworking.unregisterGlobalReceiver((Identifier)id);
    }
}

