/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.InvalidateRenderStateCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.impl.client.rendering.WorldRenderContextImpl;
import net.minecraft.block.BlockState;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gl.PostEffectProcessor;
import net.minecraft.client.render.BufferBuilderStorage;
import net.minecraft.client.render.Camera;
import net.minecraft.client.render.Frustum;
import net.minecraft.client.render.GameRenderer;
import net.minecraft.client.render.LightmapTextureManager;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.registry.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={WorldRenderer.class})
public abstract class WorldRendererMixin {
    @Final
    @Shadow
    private BufferBuilderStorage field_20951;
    @Shadow
    private ClientWorld field_4085;
    @Shadow
    private PostEffectProcessor field_25279;
    @Final
    @Shadow
    private MinecraftClient field_4088;
    @Unique
    private final WorldRenderContextImpl context = new WorldRenderContextImpl();
    @Unique
    private boolean didRenderParticles;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void beforeRender(MatrixStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightmapTextureManager lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        this.context.prepare((WorldRenderer)this, matrices, tickDelta, limitTime, renderBlockOutline, camera, gameRenderer, lightmapTextureManager, matrix4f, (VertexConsumerProvider)this.field_20951.getEntityVertexConsumers(), this.field_4085.getProfiler(), this.field_25279 != null, this.field_4085);
        ((WorldRenderEvents.Start)WorldRenderEvents.START.invoker()).onStart(this.context);
        this.didRenderParticles = false;
    }

    @Inject(method={"setupTerrain"}, at={@At(value="RETURN")})
    private void afterTerrainSetup(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        this.context.setFrustum(frustum);
        ((WorldRenderEvents.AfterSetup)WorldRenderEvents.AFTER_SETUP.invoker()).afterSetup(this.context);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;renderLayer(Lnet/minecraft/client/render/RenderLayer;Lnet/minecraft/client/util/math/MatrixStack;DDDLorg/joml/Matrix4f;)V", ordinal=2, shift=At.Shift.AFTER)})
    private void afterTerrainSolid(CallbackInfo ci) {
        ((WorldRenderEvents.BeforeEntities)WorldRenderEvents.BEFORE_ENTITIES.invoker()).beforeEntities(this.context);
    }

    @Inject(method={"render"}, at={@At(value="CONSTANT", args={"stringValue=blockentities"}, ordinal=0)})
    private void afterEntities(CallbackInfo ci) {
        ((WorldRenderEvents.AfterEntities)WorldRenderEvents.AFTER_ENTITIES.invoker()).afterEntities(this.context);
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;crosshairTarget:Lnet/minecraft/util/hit/HitResult;", shift=At.Shift.AFTER, ordinal=1)})
    private void beforeRenderOutline(CallbackInfo ci) {
        this.context.renderBlockOutline = ((WorldRenderEvents.BeforeBlockOutline)WorldRenderEvents.BEFORE_BLOCK_OUTLINE.invoker()).beforeBlockOutline(this.context, this.field_4088.crosshairTarget);
    }

    @Inject(method={"drawBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawBlockOutline(MatrixStack matrixStack, VertexConsumer vertexConsumer, Entity entity, double cameraX, double cameraY, double cameraZ, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        if (!this.context.renderBlockOutline) {
            ci.cancel();
        } else {
            this.context.prepareBlockOutline(entity, cameraX, cameraY, cameraZ, blockPos, blockState);
            if (!((WorldRenderEvents.BlockOutline)WorldRenderEvents.BLOCK_OUTLINE.invoker()).onBlockOutline(this.context, this.context)) {
                ci.cancel();
            }
            this.context.consumers().getBuffer(RenderLayer.getLines());
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/debug/DebugRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;DDD)V", ordinal=0)})
    private void beforeDebugRender(CallbackInfo ci) {
        ((WorldRenderEvents.DebugRender)WorldRenderEvents.BEFORE_DEBUG_RENDER.invoker()).beforeDebugRender(this.context);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleManager;renderParticles(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/render/LightmapTextureManager;Lnet/minecraft/client/render/Camera;F)V")})
    private void onRenderParticles(CallbackInfo ci) {
        this.didRenderParticles = true;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;push()V")})
    private void beforeClouds(CallbackInfo ci) {
        if (this.didRenderParticles) {
            this.didRenderParticles = false;
            ((WorldRenderEvents.AfterTranslucent)WorldRenderEvents.AFTER_TRANSLUCENT.invoker()).afterTranslucent(this.context);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;renderChunkDebugInfo(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/render/Camera;)V")})
    private void onChunkDebugRender(CallbackInfo ci) {
        ((WorldRenderEvents.Last)WorldRenderEvents.LAST.invoker()).onLast(this.context);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void afterRender(CallbackInfo ci) {
        ((WorldRenderEvents.End)WorldRenderEvents.END.invoker()).onEnd(this.context);
    }

    @Inject(method={"Lnet/minecraft/client/render/WorldRenderer;reload()V"}, at={@At(value="HEAD")})
    private void onReload(CallbackInfo ci) {
        ((InvalidateRenderStateCallback)InvalidateRenderStateCallback.EVENT.invoker()).onInvalidate();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderWeather"}, cancellable=true)
    private void renderWeather(LightmapTextureManager manager, float tickDelta, double x, double y, double z, CallbackInfo info) {
        DimensionRenderingRegistry.WeatherRenderer renderer;
        if (this.field_4088.world != null && (renderer = DimensionRenderingRegistry.getWeatherRenderer((RegistryKey<World>)this.field_4085.getRegistryKey())) != null) {
            renderer.render(this.context);
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FDDD)V"}, cancellable=true)
    private void renderCloud(MatrixStack matrices, Matrix4f matrix4f, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo info) {
        DimensionRenderingRegistry.CloudRenderer renderer;
        if (this.field_4088.world != null && (renderer = DimensionRenderingRegistry.getCloudRenderer((RegistryKey<World>)this.field_4085.getRegistryKey())) != null) {
            renderer.render(this.context);
            info.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/lang/Runnable;run()V", shift=At.Shift.AFTER, ordinal=0)}, method={"renderSky(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, cancellable=true)
    private void renderSky(MatrixStack matrices, Matrix4f matrix4f, float tickDelta, Camera camera, boolean bl, Runnable runnable, CallbackInfo info) {
        DimensionRenderingRegistry.SkyRenderer renderer;
        if (this.field_4088.world != null && (renderer = DimensionRenderingRegistry.getSkyRenderer((RegistryKey<World>)this.field_4085.getRegistryKey())) != null) {
            renderer.render(this.context);
            info.cancel();
        }
    }
}

