/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.tag.convention.v1;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.tag.TagKey;
import org.jetbrains.annotations.Nullable;

public final class TagUtil {
    private TagUtil() {
    }

    public static <T> boolean isIn(TagKey<T> tagKey, T entry) {
        return TagUtil.isIn(null, tagKey, entry);
    }

    public static <T> boolean isIn(@Nullable DynamicRegistryManager registryManager, TagKey<T> tagKey, T entry) {
        Registry registry;
        Optional maybeKey;
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(entry);
        Optional maybeRegistry = registryManager != null ? registryManager.getOptional(tagKey.registry()) : Registries.REGISTRIES.getOrEmpty(tagKey.registry().getValue());
        if (maybeRegistry.isPresent() && tagKey.isOf(((Registry)maybeRegistry.get()).getKey()) && (maybeKey = (registry = (Registry)maybeRegistry.get()).getKey(entry)).isPresent()) {
            return registry.entryOf((RegistryKey)maybeKey.get()).isIn(tagKey);
        }
        return false;
    }
}

