/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.option.GameOptions;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtList;
import net.minecraft.nbt.NbtString;
import net.minecraft.resource.ResourcePack;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={GameOptions.class})
public class GameOptionsMixin {
    @Shadow
    public List<String> field_1887;
    @Shadow
    @Final
    static Logger field_1834;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        File dataDir = FabricLoader.getInstance().getGameDir().resolve("data").toFile();
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            field_1834.warn("[Fabric Resource Loader] Could not create data directory: " + dataDir.getAbsolutePath());
        }
        File trackerFile = new File(dataDir, "fabricDefaultResourcePacks.dat");
        HashSet<String> trackedPacks = new HashSet<String>();
        if (trackerFile.exists()) {
            try {
                NbtCompound data = NbtIo.readCompressed((File)trackerFile);
                NbtList values = data.getList("values", 8);
                for (int i = 0; i < values.size(); ++i) {
                    trackedPacks.add(values.getString(i));
                }
            }
            catch (IOException e) {
                field_1834.warn("[Fabric Resource Loader] Could not read " + trackerFile.getAbsolutePath(), (Throwable)e);
            }
        }
        HashSet removedPacks = new HashSet(trackedPacks);
        LinkedHashSet<String> resourcePacks = new LinkedHashSet<String>(this.field_1887);
        ArrayList profiles = new ArrayList();
        ModResourcePackCreator.CLIENT_RESOURCE_PACK_PROVIDER.register(profiles::add);
        for (Object profile : profiles) {
            if (profile.getSource() == ModResourcePackCreator.RESOURCE_PACK_SOURCE) {
                resourcePacks.add(profile.getName());
                continue;
            }
            ResourcePack pack = profile.createResourcePack();
            try {
                ModNioResourcePack builtinPack;
                if (!(pack instanceof ModNioResourcePack) || !(builtinPack = (ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) continue;
                if (trackedPacks.add(builtinPack.getName())) {
                    resourcePacks.add(profile.getName());
                    continue;
                }
                removedPacks.remove(builtinPack.getName());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        try {
            NbtList values = new NbtList();
            for (String id : trackedPacks) {
                if (removedPacks.contains(id)) continue;
                values.add((Object)NbtString.of((String)id));
            }
            NbtCompound nbt = new NbtCompound();
            nbt.put("values", (NbtElement)values);
            NbtIo.writeCompressed((NbtCompound)nbt, (File)trackerFile);
        }
        catch (IOException e) {
            field_1834.warn("[Fabric Resource Loader] Could not write to " + trackerFile.getAbsolutePath(), (Throwable)e);
        }
        this.field_1887 = new ArrayList<String>(resourcePacks);
    }
}

