/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.FabricModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.SharedConstants;
import net.minecraft.resource.DataConfiguration;
import net.minecraft.resource.DataPackSettings;
import net.minecraft.resource.ResourcePack;
import net.minecraft.resource.ResourcePackProfile;
import net.minecraft.resource.ResourceType;
import net.minecraft.resource.featuretoggle.FeatureFlags;
import net.minecraft.text.Text;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class ModResourcePackUtil {
    private static final Gson GSON = new Gson();

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, ResourceType type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin") || (pack = ModNioResourcePack.create(container.getMetadata().getId(), container, subPath, type, ResourcePackActivationType.ALWAYS_ENABLED)) == null) continue;
            packs.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, ResourceType type, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = Objects.requireNonNullElse(info.getName(), "");
                String metadata = ModResourcePackUtil.serializeMetadata(SharedConstants.getGameVersion().getResourceVersion(type), description);
                return IOUtils.toInputStream((String)metadata, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }

    public static String serializeMetadata(int packVersion, String description) {
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)packVersion);
        pack.addProperty("description", description);
        JsonObject metadata = new JsonObject();
        metadata.add("pack", (JsonElement)pack);
        return GSON.toJson((JsonElement)metadata);
    }

    public static Text getName(ModMetadata info) {
        if (info.getName() != null) {
            return Text.literal((String)info.getName());
        }
        return Text.translatable((String)"pack.name.fabricMod", (Object[])new Object[]{info.getId()});
    }

    public static DataConfiguration createDefaultDataConfiguration() {
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(ResourceType.SERVER_DATA);
        ArrayList moddedResourcePacks = new ArrayList();
        modResourcePackCreator.register(moddedResourcePacks::add);
        ArrayList<String> enabled = new ArrayList<String>(DataPackSettings.SAFE_MODE.getEnabled());
        ArrayList<String> disabled = new ArrayList<String>(DataPackSettings.SAFE_MODE.getDisabled());
        for (ResourcePackProfile profile : moddedResourcePacks) {
            ResourcePack pack = profile.createResourcePack();
            try {
                if (pack instanceof FabricModResourcePack || pack instanceof ModNioResourcePack && ((ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) {
                    enabled.add(profile.getName());
                    continue;
                }
                disabled.add(profile.getName());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        return new DataConfiguration(new DataPackSettings(enabled, disabled), FeatureFlags.DEFAULT_ENABLED_FEATURES);
    }

    public static DataPackSettings createTestServerSettings(List<String> enabled, List<String> disabled) {
        HashSet moddedProfiles = new HashSet();
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(ResourceType.SERVER_DATA);
        modResourcePackCreator.register(profile -> moddedProfiles.add(profile.getName()));
        ArrayList<String> moveToTheEnd = new ArrayList<String>();
        Iterator<String> it = enabled.iterator();
        while (it.hasNext()) {
            String profile2 = it.next();
            if (!moddedProfiles.contains(profile2)) continue;
            moveToTheEnd.add(profile2);
            it.remove();
        }
        enabled.addAll(moveToTheEnd);
        return new DataPackSettings(enabled, disabled);
    }
}

