/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resource.InputSupplier;
import net.minecraft.resource.NamespaceResourceManager;
import net.minecraft.resource.Resource;
import net.minecraft.resource.ResourcePack;
import net.minecraft.resource.ResourceType;
import net.minecraft.resource.metadata.ResourceMetadata;
import net.minecraft.util.Identifier;

public abstract class GroupResourcePack
implements ResourcePack {
    protected final ResourceType type;
    protected final List<? extends ResourcePack> packs;
    protected final Map<String, List<ResourcePack>> namespacedPacks = new Object2ObjectOpenHashMap();

    public GroupResourcePack(ResourceType type, List<? extends ResourcePack> packs) {
        this.type = type;
        this.packs = packs;
        this.packs.forEach(pack -> pack.getNamespaces(this.type).forEach(namespace -> this.namespacedPacks.computeIfAbsent((String)namespace, value -> new ArrayList()).add(pack)));
    }

    public InputSupplier<InputStream> open(ResourceType type, Identifier id) {
        List<ResourcePack> packs = this.namespacedPacks.get(id.getNamespace());
        if (packs != null) {
            for (int i = packs.size() - 1; i >= 0; --i) {
                ResourcePack pack = packs.get(i);
                InputSupplier supplier = pack.open(type, id);
                if (supplier == null) continue;
                return supplier;
            }
        }
        return null;
    }

    public void findResources(ResourceType type, String namespace, String prefix, ResourcePack.ResultConsumer consumer) {
        List<ResourcePack> packs = this.namespacedPacks.get(namespace);
        if (packs == null) {
            return;
        }
        for (ResourcePack pack : packs) {
            pack.findResources(type, namespace, prefix, consumer);
        }
    }

    public Set<String> getNamespaces(ResourceType type) {
        return this.namespacedPacks.keySet();
    }

    public void appendResources(ResourceType type, Identifier id, List<Resource> resources) {
        List<ResourcePack> packs = this.namespacedPacks.get(id.getNamespace());
        if (packs == null) {
            return;
        }
        Identifier metadataId = NamespaceResourceManager.getMetadataPath((Identifier)id);
        for (int i = packs.size() - 1; i >= 0; --i) {
            ResourcePack pack = packs.get(i);
            InputSupplier supplier = pack.open(type, id);
            if (supplier == null) continue;
            InputSupplier metadataSupplier = () -> {
                InputSupplier rawMetadataSupplier = pack.open(this.type, metadataId);
                return rawMetadataSupplier != null ? NamespaceResourceManager.loadMetadata((InputSupplier)rawMetadataSupplier) : ResourceMetadata.NONE;
            };
            resources.add(new Resource(pack, supplier, metadataSupplier));
        }
    }

    public String getFullName() {
        return this.getName() + " (" + this.packs.stream().map(ResourcePack::getName).collect(Collectors.joining(", ")) + ")";
    }

    public void close() {
        this.packs.forEach(ResourcePack::close);
    }
}

