/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.OverlayVertexConsumer;
import net.minecraft.util.math.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Environment(value=EnvType.CLIENT)
@Mixin(value={OverlayVertexConsumer.class})
public class OverlayVertexConsumerMixin {
    @Unique
    private static final Direction[] DIRECTIONS = Direction.values();

    @Redirect(method={"next()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Direction;getFacing(FFF)Lnet/minecraft/util/math/Direction;"))
    private Direction redirectGetFacing(float x, float y, float z) {
        Direction closestDir = Direction.NORTH;
        float maxDot = Float.MIN_VALUE;
        for (Direction direction : DIRECTIONS) {
            float dot = x * (float)direction.getOffsetX() + y * (float)direction.getOffsetY() + z * (float)direction.getOffsetZ();
            if (!(dot > maxDot + 1.0E-6f)) continue;
            maxDot = dot;
            closestDir = direction;
        }
        return closestDir;
    }
}

