/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.interaction;

import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.PlayerActionC2SPacket;
import net.minecraft.network.packet.s2c.play.BlockUpdateS2CPacket;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.network.ServerPlayerInteractionManager;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.TypedActionResult;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.BlockView;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayerInteractionManager.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    protected ServerWorld field_14007;
    @Final
    @Shadow
    protected ServerPlayerEntity field_14008;

    @Inject(at={@At(value="HEAD")}, method={"processBlockBreakingAction"}, cancellable=true)
    public void startBlockBreak(BlockPos pos, PlayerActionC2SPacket.Action playerAction, Direction direction, int worldHeight, int i, CallbackInfo info) {
        if (playerAction != PlayerActionC2SPacket.Action.START_DESTROY_BLOCK) {
            return;
        }
        ActionResult result = ((AttackBlockCallback)AttackBlockCallback.EVENT.invoker()).interact((PlayerEntity)this.field_14008, (World)this.field_14007, Hand.MAIN_HAND, pos, direction);
        if (result != ActionResult.PASS) {
            Packet updatePacket;
            BlockEntity blockEntity;
            this.field_14008.networkHandler.sendPacket((Packet)new BlockUpdateS2CPacket((BlockView)this.field_14007, pos));
            if (this.field_14007.getBlockState(pos).hasBlockEntity() && (blockEntity = this.field_14007.getBlockEntity(pos)) != null && (updatePacket = blockEntity.toUpdatePacket()) != null) {
                this.field_14008.networkHandler.sendPacket(updatePacket);
            }
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"interactBlock"}, cancellable=true)
    public void interactBlock(ServerPlayerEntity player, World world, ItemStack stack, Hand hand, BlockHitResult blockHitResult, CallbackInfoReturnable<ActionResult> info) {
        ActionResult result = ((UseBlockCallback)UseBlockCallback.EVENT.invoker()).interact((PlayerEntity)player, world, hand, blockHitResult);
        if (result != ActionResult.PASS) {
            info.setReturnValue((Object)result);
            info.cancel();
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"interactItem"}, cancellable=true)
    public void interactItem(ServerPlayerEntity player, World world, ItemStack stack, Hand hand, CallbackInfoReturnable<ActionResult> info) {
        TypedActionResult<ItemStack> result = ((UseItemCallback)UseItemCallback.EVENT.invoker()).interact((PlayerEntity)player, world, hand);
        if (result.getResult() != ActionResult.PASS) {
            info.setReturnValue((Object)result.getResult());
            info.cancel();
            return;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)V")}, method={"tryBreakBlock"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void breakBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir, BlockState state, BlockEntity entity, Block block) {
        boolean result = ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak((World)this.field_14007, (PlayerEntity)this.field_14008, pos, state, entity);
        if (!result) {
            ((PlayerBlockBreakEvents.Canceled)PlayerBlockBreakEvents.CANCELED.invoker()).onBlockBreakCanceled((World)this.field_14007, (PlayerEntity)this.field_14008, pos, state, entity);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onBroken(Lnet/minecraft/world/WorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V")}, method={"tryBreakBlock"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onBlockBroken(BlockPos pos, CallbackInfoReturnable<Boolean> cir, BlockState state, BlockEntity entity, Block block, boolean b1) {
        ((PlayerBlockBreakEvents.After)PlayerBlockBreakEvents.AFTER.invoker()).afterBlockBreak((World)this.field_14007, (PlayerEntity)this.field_14008, pos, state, entity);
    }
}

