/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.ListenableRegistry;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemapStateImpl;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.registry.MutableRegistry;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.SimpleRegistry;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SimpleRegistry.class})
public abstract class SimpleRegistryMixin<T>
implements MutableRegistry<T>,
RemappableRegistry,
ListenableRegistry<T> {
    @Unique
    private static final Set<String> VANILLA_NAMESPACES = Set.of("minecraft", "brigadier");
    @Shadow
    @Final
    private ObjectList<RegistryEntry.Reference<T>> field_26682;
    @Shadow
    @Final
    private Object2IntMap<T> field_26683;
    @Shadow
    @Final
    private Map<Identifier, RegistryEntry.Reference<T>> field_11107;
    @Shadow
    @Final
    private Map<RegistryKey<T>, RegistryEntry.Reference<T>> field_25067;
    @Shadow
    private int field_11109;
    @Unique
    private static final Logger FABRIC_LOGGER = LoggerFactory.getLogger(SimpleRegistryMixin.class);
    @Unique
    private final Event<RegistryEntryAddedCallback<T>> fabric_addObjectEvent = EventFactory.createArrayBacked(RegistryEntryAddedCallback.class, callbacks -> (rawId, id, object) -> {
        for (RegistryEntryAddedCallback callback : callbacks) {
            callback.onEntryAdded(rawId, id, object);
        }
    });
    @Unique
    private final Event<RegistryEntryRemovedCallback<T>> fabric_removeObjectEvent = EventFactory.createArrayBacked(RegistryEntryRemovedCallback.class, callbacks -> (rawId, id, object) -> {
        for (RegistryEntryRemovedCallback callback : callbacks) {
            callback.onEntryRemoved(rawId, id, object);
        }
    });
    @Unique
    private final Event<RegistryIdRemapCallback<T>> fabric_postRemapEvent = EventFactory.createArrayBacked(RegistryIdRemapCallback.class, callbacks -> a -> {
        for (RegistryIdRemapCallback callback : callbacks) {
            callback.onRemap(a);
        }
    });
    @Unique
    private Object2IntMap<Identifier> fabric_prevIndexedEntries;
    @Unique
    private BiMap<Identifier, RegistryEntry.Reference<T>> fabric_prevEntries;
    @Unique
    private boolean fabric_isObjectNew = false;

    @Shadow
    public abstract Optional<RegistryKey<T>> getKey(T var1);

    @Shadow
    @Nullable
    public abstract T get(@Nullable Identifier var1);

    @Shadow
    public abstract RegistryKey<? extends Registry<T>> getKey();

    @Override
    public Event<RegistryEntryAddedCallback<T>> fabric_getAddObjectEvent() {
        return this.fabric_addObjectEvent;
    }

    @Override
    public Event<RegistryEntryRemovedCallback<T>> fabric_getRemoveObjectEvent() {
        return this.fabric_removeObjectEvent;
    }

    @Override
    public Event<RegistryIdRemapCallback<T>> fabric_getRemapEvent() {
        return this.fabric_postRemapEvent;
    }

    @Inject(method={"add"}, at={@At(value="RETURN")})
    private <V extends T> void add(RegistryKey<Registry<T>> registryKey, V entry, Lifecycle lifecycle, CallbackInfoReturnable<V> info) {
        this.onChange(registryKey);
    }

    @Inject(method={"set"}, at={@At(value="RETURN")})
    private <V extends T> void set(int rawId, RegistryKey<Registry<T>> registryKey, V entry, Lifecycle lifecycle, CallbackInfoReturnable<RegistryEntry<T>> info) {
        Object object = info.getReturnValue();
        if (object instanceof RegistryEntry.Reference) {
            RegistryEntry.Reference reference = (RegistryEntry.Reference)object;
            reference.setValue(entry);
        }
        this.onChange(registryKey);
    }

    @Unique
    private void onChange(RegistryKey<Registry<T>> registryKey) {
        RegistryAttributeHolder holder;
        if (!(!RegistrySyncManager.postBootstrap && VANILLA_NAMESPACES.contains(registryKey.getValue().getNamespace()) || (holder = RegistryAttributeHolder.get(this.getKey())).hasAttribute(RegistryAttribute.MODDED))) {
            Identifier id = this.getKey().getValue();
            FABRIC_LOGGER.debug("Registry {} has been marked as modded, registry entry {} was changed", (Object)id, (Object)registryKey.getValue());
            RegistryAttributeHolder.get(this.getKey()).addAttribute(RegistryAttribute.MODDED);
        }
    }

    @Inject(method={"set"}, at={@At(value="HEAD")})
    public void setPre(int id, RegistryKey<T> registryId, T object, Lifecycle lifecycle, CallbackInfoReturnable<RegistryEntry<T>> info) {
        int indexedEntriesId = this.field_26683.getInt(object);
        if (indexedEntriesId >= 0) {
            throw new RuntimeException("Attempted to register object " + String.valueOf(object) + " twice! (at raw IDs " + indexedEntriesId + " and " + id + " )");
        }
        if (!this.field_11107.containsKey(registryId.getValue())) {
            this.fabric_isObjectNew = true;
        } else {
            RegistryEntry.Reference<T> oldObject = this.field_11107.get(registryId.getValue());
            if (oldObject != null && oldObject.value() != null && oldObject.value() != object) {
                int oldId = this.field_26683.getInt(oldObject.value());
                if (oldId != id) {
                    throw new RuntimeException("Attempted to register ID " + String.valueOf(registryId) + " at different raw IDs (" + oldId + ", " + id + ")! If you're trying to override an item, use .set(), not .register()!");
                }
                ((RegistryEntryRemovedCallback)this.fabric_removeObjectEvent.invoker()).onEntryRemoved(oldId, registryId.getValue(), oldObject.value());
                this.fabric_isObjectNew = true;
            } else {
                this.fabric_isObjectNew = false;
            }
        }
    }

    @Inject(method={"set"}, at={@At(value="RETURN")})
    public void setPost(int id, RegistryKey<T> registryId, T object, Lifecycle lifecycle, CallbackInfoReturnable<RegistryEntry<T>> info) {
        if (this.fabric_isObjectNew) {
            ((RegistryEntryAddedCallback)this.fabric_addObjectEvent.invoker()).onEntryAdded(id, registryId.getValue(), object);
        }
    }

    @Override
    public void remap(String name, Object2IntMap<Identifier> remoteIndexedEntries, RemappableRegistry.RemapMode mode) throws RemapException {
        IntIterator id2;
        Iterator o;
        switch (mode) {
            case AUTHORITATIVE: {
                break;
            }
            case REMOTE: {
                ArrayList<CallSite> strings = null;
                for (Object remoteId2 : remoteIndexedEntries.keySet()) {
                    if (this.field_11107.containsKey(remoteId2)) continue;
                    if (strings == null) {
                        strings = new ArrayList<CallSite>();
                    }
                    strings.add((CallSite)((Object)(" - " + String.valueOf(remoteId2))));
                }
                if (strings == null) break;
                StringBuilder builder = new StringBuilder("Received ID map for " + name + " contains IDs unknown to the receiver!");
                for (String string : strings) {
                    builder.append('\n').append(string);
                }
                throw new RemapException(builder.toString());
            }
            case EXACT: {
                if (this.field_11107.keySet().equals(remoteIndexedEntries.keySet())) break;
                ArrayList<CallSite> strings2 = new ArrayList<CallSite>();
                for (Identifier remoteId : remoteIndexedEntries.keySet()) {
                    if (this.field_11107.containsKey(remoteId)) continue;
                    strings2.add((CallSite)((Object)(" - " + String.valueOf(remoteId) + " (missing on local)")));
                }
                for (Object localId : this.getIds()) {
                    if (remoteIndexedEntries.containsKey(localId)) continue;
                    strings2.add((CallSite)((Object)(" - " + String.valueOf(localId) + " (missing on remote)")));
                }
                StringBuilder builder = new StringBuilder("Local and remote ID sets for " + name + " do not match!");
                for (String string : strings2) {
                    builder.append('\n').append(string);
                }
                throw new RemapException(builder.toString());
            }
        }
        if (this.fabric_prevIndexedEntries == null) {
            this.fabric_prevIndexedEntries = new Object2IntOpenHashMap();
            this.fabric_prevEntries = HashBiMap.create(this.field_11107);
            Iterator strings2 = this.iterator();
            while (strings2.hasNext()) {
                o = strings2.next();
                this.fabric_prevIndexedEntries.put((Object)this.getId(o), this.getRawId(o));
            }
        }
        Int2ObjectOpenHashMap oldIdMap = new Int2ObjectOpenHashMap();
        o = this.iterator();
        while (o.hasNext()) {
            Object o2 = o.next();
            oldIdMap.put(this.getRawId(o2), (Object)this.getId(o2));
        }
        switch (mode) {
            case AUTHORITATIVE: {
                int maxValue = 0;
                Object2IntOpenHashMap oldRemoteIndexedEntries = remoteIndexedEntries;
                remoteIndexedEntries = new Object2IntOpenHashMap();
                for (Identifier id2 : oldRemoteIndexedEntries.keySet()) {
                    int v = oldRemoteIndexedEntries.getInt((Object)id2);
                    remoteIndexedEntries.put((Object)id2, v);
                    if (v <= maxValue) continue;
                    maxValue = v;
                }
                for (IntIterator id2 : this.getIds()) {
                    if (remoteIndexedEntries.containsKey((Object)id2)) continue;
                    FABRIC_LOGGER.warn("Adding " + String.valueOf(id2) + " to saved/remote registry.");
                    remoteIndexedEntries.put((Object)id2, ++maxValue);
                }
                break;
            }
            case REMOTE: {
                int maxId = -1;
                for (Identifier identifier : this.getIds()) {
                    if (remoteIndexedEntries.containsKey((Object)identifier)) continue;
                    if (maxId < 0) {
                        id2 = remoteIndexedEntries.values().iterator();
                        while (id2.hasNext()) {
                            int value = (Integer)id2.next();
                            if (value <= maxId) continue;
                            maxId = value;
                        }
                    }
                    if (maxId < 0) {
                        throw new RemapException("Failed to assign new id to client only registry entry");
                    }
                    FABRIC_LOGGER.debug("An ID for {} was not sent by the server, assuming client only registry entry and assigning a new id ({}) in {}", new Object[]{identifier.toString(), ++maxId, this.getKey().getValue().toString()});
                    remoteIndexedEntries.put((Object)identifier, maxId);
                }
                break;
            }
        }
        Int2IntOpenHashMap idMap = new Int2IntOpenHashMap();
        for (int i = 0; i < this.field_26682.size(); ++i) {
            RegistryEntry.Reference reference = (RegistryEntry.Reference)this.field_26682.get(i);
            if (reference == null || !remoteIndexedEntries.containsKey((Object)(id2 = reference.registryKey().getValue()))) continue;
            idMap.put(i, remoteIndexedEntries.getInt((Object)id2));
        }
        this.field_26682.clear();
        this.field_26683.clear();
        this.field_11109 = 0;
        ArrayList<Identifier> orderedRemoteEntries = new ArrayList<Identifier>((Collection<Identifier>)remoteIndexedEntries.keySet());
        orderedRemoteEntries.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)remoteIndexedEntries).getInt(arg_0)));
        for (Identifier identifier : orderedRemoteEntries) {
            int id4 = remoteIndexedEntries.getInt((Object)identifier);
            RegistryEntry.Reference<T> object = this.field_11107.get(identifier);
            if (object == null) {
                if (mode != RemappableRegistry.RemapMode.AUTHORITATIVE) {
                    throw new RemapException(String.valueOf(identifier) + " missing from registry, but requested!");
                }
                FABRIC_LOGGER.warn(String.valueOf(identifier) + " missing from registry, but requested!");
                continue;
            }
            this.field_26682.size(Math.max(this.field_26682.size(), id4 + 1));
            this.field_26682.set(id4, object);
            this.field_26683.put(object.value(), id4);
            if (this.field_11109 > id4) continue;
            this.field_11109 = id4 + 1;
        }
        ((RegistryIdRemapCallback)this.fabric_getRemapEvent().invoker()).onRemap(new RemapStateImpl(this, (Int2ObjectMap<Identifier>)oldIdMap, (Int2IntMap)idMap));
    }

    @Override
    public void unmap(String name) throws RemapException {
        if (this.fabric_prevIndexedEntries != null) {
            ArrayList<Identifier> addedIds = new ArrayList<Identifier>();
            for (Identifier id : this.fabric_prevEntries.keySet()) {
                if (this.field_11107.containsKey(id)) continue;
                assert (this.fabric_prevIndexedEntries.containsKey((Object)id));
                addedIds.add(id);
            }
            this.field_11107.clear();
            this.field_25067.clear();
            this.field_11107.putAll((Map<Identifier, RegistryEntry.Reference<T>>)this.fabric_prevEntries);
            for (Map.Entry entry : this.fabric_prevEntries.entrySet()) {
                RegistryKey entryKey = RegistryKey.of(this.getKey(), (Identifier)((Identifier)entry.getKey()));
                this.field_25067.put(entryKey, (RegistryEntry.Reference)entry.getValue());
            }
            this.remap(name, this.fabric_prevIndexedEntries, RemappableRegistry.RemapMode.AUTHORITATIVE);
            for (Identifier id : addedIds) {
                ((RegistryEntryAddedCallback)this.fabric_getAddObjectEvent().invoker()).onEntryAdded(this.field_26683.getInt(this.field_11107.get(id)), id, this.get(id));
            }
            this.fabric_prevIndexedEntries = null;
            this.fabric_prevEntries = null;
        }
    }
}

