/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import net.fabricmc.fabric.impl.registry.sync.RegistryMapSerializer;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtIo;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.util.Identifier;
import net.minecraft.world.SaveProperties;
import net.minecraft.world.level.storage.LevelStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorage.Session.class})
public class LevelStorageSessionMixin {
    @Unique
    private static final int FABRIC_ID_REGISTRY_BACKUPS = 3;
    @Unique
    private static final Logger FABRIC_LOGGER = LoggerFactory.getLogger((String)"FabricRegistrySync");
    @Unique
    private Map<Identifier, Object2IntMap<Identifier>> fabric_lastSavedRegistryMap = null;
    @Unique
    private Map<Identifier, Object2IntMap<Identifier>> fabric_activeRegistryMap = null;
    @Shadow
    @Final
    private LevelStorage.LevelSave field_23768;

    @Unique
    private boolean fabric_readIdMapFile(File file) throws IOException, RemapException {
        FABRIC_LOGGER.debug("Reading registry data from " + file.toString());
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            NbtCompound tag = NbtIo.readCompressed((InputStream)fileInputStream);
            fileInputStream.close();
            if (tag != null) {
                this.fabric_activeRegistryMap = RegistryMapSerializer.fromNbt(tag);
                RegistrySyncManager.apply(this.fabric_activeRegistryMap, RemappableRegistry.RemapMode.AUTHORITATIVE);
                return true;
            }
        }
        return false;
    }

    @Unique
    private File fabric_getWorldIdMapFile(int i) {
        return new File(new File(this.field_23768.path().toFile(), "data"), "fabricRegistry.dat" + (String)(i == 0 ? "" : "." + i));
    }

    @Unique
    private void fabric_saveRegistryData() {
        FABRIC_LOGGER.debug("Starting registry save");
        Map<Identifier, Object2IntMap<Identifier>> newMap = RegistrySyncManager.createAndPopulateRegistryMap(false, this.fabric_activeRegistryMap);
        if (newMap == null) {
            FABRIC_LOGGER.debug("Not saving empty registry data");
            return;
        }
        if (!newMap.equals(this.fabric_lastSavedRegistryMap)) {
            for (int i = 2; i >= 0; --i) {
                File file = this.fabric_getWorldIdMapFile(i);
                if (!file.exists()) continue;
                if (i == 2) {
                    file.delete();
                    continue;
                }
                File target = this.fabric_getWorldIdMapFile(i + 1);
                file.renameTo(target);
            }
            try {
                File file = this.fabric_getWorldIdMapFile(0);
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    FABRIC_LOGGER.warn("[fabric-registry-sync] Could not create directory " + String.valueOf(parentFile) + "!");
                }
                FABRIC_LOGGER.debug("Saving registry data to " + String.valueOf(file));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                NbtIo.writeCompressed((NbtCompound)RegistryMapSerializer.toNbt(newMap), (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                FABRIC_LOGGER.warn("[fabric-registry-sync] Failed to save registry file!", (Throwable)e);
            }
            this.fabric_lastSavedRegistryMap = newMap;
        }
    }

    @Inject(method={"backupLevelDataFile(Lnet/minecraft/registry/DynamicRegistryManager;Lnet/minecraft/world/SaveProperties;Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")})
    public void saveWorld(DynamicRegistryManager registryTracker, SaveProperties saveProperties, NbtCompound compoundTag, CallbackInfo info) {
        if (!Files.exists(this.field_23768.path(), new LinkOption[0])) {
            return;
        }
        this.fabric_saveRegistryData();
    }

    @Inject(method={"readLevelProperties"}, at={@At(value="HEAD")})
    public void readWorldProperties(CallbackInfoReturnable<SaveProperties> callbackInfo) {
        for (int i = 0; i < 3; ++i) {
            FABRIC_LOGGER.trace("[fabric-registry-sync] Loading Fabric registry [file " + (i + 1) + "/4]");
            try {
                if (!this.fabric_readIdMapFile(this.fabric_getWorldIdMapFile(i))) continue;
                FABRIC_LOGGER.info("[fabric-registry-sync] Loaded registry data [file " + (i + 1) + "/4]");
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException e) {
                if (i >= 2) {
                    throw new RuntimeException(e);
                }
                FABRIC_LOGGER.warn("Reading registry file failed!", (Throwable)e);
                continue;
            }
            catch (RemapException e) {
                throw new RuntimeException("Remapping world failed!", e);
            }
        }
        this.fabric_saveRegistryData();
    }
}

