/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class DirectRegistryPacketHandler
extends RegistryPacketHandler {
    private static final int MAX_PAYLOAD_SIZE = Integer.getInteger("fabric.registry.direct.maxPayloadSize", 0x100000);
    private static final Identifier ID = new Identifier("fabric", "registry/sync/direct");
    @Nullable
    private PacketByteBuf combinedBuf;
    @Nullable
    private Map<Identifier, Object2IntMap<Identifier>> syncedRegistryMap;
    private boolean isPacketFinished = false;
    private int totalPacketReceived = 0;

    @Override
    public Identifier getPacketId() {
        return ID;
    }

    @Override
    public void sendPacket(ServerPlayerEntity player, Map<Identifier, Object2IntMap<Identifier>> registryMap) {
        int sliceSize;
        PacketByteBuf buf = PacketByteBufs.create();
        Map<String, List<Identifier>> regNamespaceGroups = registryMap.keySet().stream().collect(Collectors.groupingBy(Identifier::getNamespace));
        buf.writeVarInt(regNamespaceGroups.size());
        regNamespaceGroups.forEach((regNamespace, regIds) -> {
            buf.writeString(DirectRegistryPacketHandler.optimizeNamespace(regNamespace));
            buf.writeVarInt(regIds.size());
            for (Identifier regId : regIds) {
                buf.writeString(regId.getPath());
                Object2IntMap idMap = (Object2IntMap)registryMap.get(regId);
                Map idNamespaceGroups = idMap.object2IntEntrySet().stream().collect(Collectors.groupingBy(e -> ((Identifier)e.getKey()).getNamespace(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                buf.writeVarInt(idNamespaceGroups.size());
                int lastBulkLastRawId = 0;
                for (Map.Entry idNamespaceEntry : idNamespaceGroups.entrySet()) {
                    List idPairs = (List)idNamespaceEntry.getValue();
                    idPairs.sort(Comparator.comparingInt(Object2IntMap.Entry::getIntValue));
                    ArrayList bulks = new ArrayList();
                    Iterator idPairIter = idPairs.iterator();
                    ArrayList<Object2IntMap.Entry> currentBulk = new ArrayList<Object2IntMap.Entry>();
                    Object2IntMap.Entry currentPair = (Object2IntMap.Entry)idPairIter.next();
                    currentBulk.add(currentPair);
                    while (idPairIter.hasNext()) {
                        currentPair = (Object2IntMap.Entry)idPairIter.next();
                        if (((Object2IntMap.Entry)currentBulk.get(currentBulk.size() - 1)).getIntValue() + 1 != currentPair.getIntValue()) {
                            bulks.add(currentBulk);
                            currentBulk = new ArrayList();
                        }
                        currentBulk.add(currentPair);
                    }
                    bulks.add(currentBulk);
                    buf.writeString(DirectRegistryPacketHandler.optimizeNamespace((String)idNamespaceEntry.getKey()));
                    buf.writeVarInt(bulks.size());
                    for (List list : bulks) {
                        int firstRawId = ((Object2IntMap.Entry)list.get(0)).getIntValue();
                        int bulkRawIdStartDiff = firstRawId - lastBulkLastRawId;
                        buf.writeVarInt(bulkRawIdStartDiff);
                        buf.writeVarInt(list.size());
                        for (Object2IntMap.Entry idPair : list) {
                            buf.writeString(((Identifier)idPair.getKey()).getPath());
                            lastBulkLastRawId = idPair.getIntValue();
                        }
                    }
                }
            }
        });
        int readableBytes = buf.readableBytes();
        for (int sliceIndex = 0; sliceIndex < readableBytes; sliceIndex += sliceSize) {
            sliceSize = Math.min(readableBytes - sliceIndex, MAX_PAYLOAD_SIZE);
            PacketByteBuf slicedBuf = PacketByteBufs.slice((ByteBuf)buf, (int)sliceIndex, (int)sliceSize);
            this.sendPacket(player, slicedBuf);
        }
        this.sendPacket(player, PacketByteBufs.empty());
    }

    @Override
    public void receivePacket(PacketByteBuf slicedBuf) {
        Preconditions.checkState((!this.isPacketFinished ? 1 : 0) != 0);
        ++this.totalPacketReceived;
        if (this.combinedBuf == null) {
            this.combinedBuf = PacketByteBufs.create();
        }
        if (slicedBuf.readableBytes() != 0) {
            this.combinedBuf.writeBytes((ByteBuf)slicedBuf);
            return;
        }
        this.isPacketFinished = true;
        this.computeBufSize(this.combinedBuf);
        this.syncedRegistryMap = new LinkedHashMap<Identifier, Object2IntMap<Identifier>>();
        int regNamespaceGroupAmount = this.combinedBuf.readVarInt();
        for (int i = 0; i < regNamespaceGroupAmount; ++i) {
            String regNamespace = DirectRegistryPacketHandler.unoptimizeNamespace(this.combinedBuf.readString());
            int regNamespaceGroupLength = this.combinedBuf.readVarInt();
            for (int j = 0; j < regNamespaceGroupLength; ++j) {
                String regPath = this.combinedBuf.readString();
                Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
                int idNamespaceGroupAmount = this.combinedBuf.readVarInt();
                int lastBulkLastRawId = 0;
                for (int k = 0; k < idNamespaceGroupAmount; ++k) {
                    String idNamespace = DirectRegistryPacketHandler.unoptimizeNamespace(this.combinedBuf.readString());
                    int rawIdBulkAmount = this.combinedBuf.readVarInt();
                    for (int l = 0; l < rawIdBulkAmount; ++l) {
                        int bulkRawIdStartDiff = this.combinedBuf.readVarInt();
                        int bulkSize = this.combinedBuf.readVarInt();
                        int currentRawId = lastBulkLastRawId + bulkRawIdStartDiff - 1;
                        for (int m = 0; m < bulkSize; ++m) {
                            String idPath = this.combinedBuf.readString();
                            idMap.put((Object)new Identifier(idNamespace, idPath), ++currentRawId);
                        }
                        lastBulkLastRawId = currentRawId;
                    }
                }
                this.syncedRegistryMap.put(new Identifier(regNamespace, regPath), (Object2IntMap<Identifier>)idMap);
            }
        }
        this.combinedBuf.release();
        this.combinedBuf = null;
    }

    @Override
    public boolean isPacketFinished() {
        return this.isPacketFinished;
    }

    @Override
    public int getTotalPacketReceived() {
        Preconditions.checkState((boolean)this.isPacketFinished);
        return this.totalPacketReceived;
    }

    @Override
    @Nullable
    public Map<Identifier, Object2IntMap<Identifier>> getSyncedRegistryMap() {
        Preconditions.checkState((boolean)this.isPacketFinished);
        Map<Identifier, Object2IntMap<Identifier>> map = this.syncedRegistryMap;
        this.isPacketFinished = false;
        this.totalPacketReceived = 0;
        this.syncedRegistryMap = null;
        return map;
    }

    private static String optimizeNamespace(String namespace) {
        return namespace.equals("minecraft") ? "" : namespace;
    }

    private static String unoptimizeNamespace(String namespace) {
        return namespace.isEmpty() ? "minecraft" : namespace;
    }
}

