/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.registry.sync;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FabricRegistryClientInit
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricRegistryClientInit.class);

    public void onInitializeClient() {
        this.registerSyncPacketReceiver(RegistrySyncManager.DIRECT_PACKET_HANDLER);
    }

    private void registerSyncPacketReceiver(RegistryPacketHandler packetHandler) {
        ClientPlayNetworking.registerGlobalReceiver((Identifier)packetHandler.getPacketId(), (client, handler, buf, responseSender) -> RegistrySyncManager.receivePacket(client, packetHandler, buf, RegistrySyncManager.DEBUG || !client.isInSingleplayer(), e -> {
            LOGGER.error("Registry remapping failed!", (Throwable)e);
            client.execute(() -> handler.getConnection().disconnect(this.getText((Exception)e)));
        }));
    }

    private Text getText(Exception e) {
        RemapException remapException;
        Text text;
        if (e instanceof RemapException && (text = (remapException = (RemapException)e).getText()) != null) {
            return text;
        }
        return Text.literal((String)("Registry remapping failed: " + e.getMessage()));
    }
}

