/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractBlockRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ChunkRenderInfo;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.OverlayTexture;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.chunk.BlockBufferBuilderStorage;
import net.minecraft.client.render.chunk.ChunkBuilder;
import net.minecraft.client.render.chunk.ChunkRendererRegion;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.util.crash.CrashException;
import net.minecraft.util.crash.CrashReport;
import net.minecraft.util.crash.CrashReportSection;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.BlockRenderView;
import net.minecraft.world.BlockView;
import net.minecraft.world.HeightLimitView;

@Environment(value=EnvType.CLIENT)
public class TerrainRenderContext
extends AbstractBlockRenderContext {
    public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);
    private final ChunkRenderInfo chunkInfo = new ChunkRenderInfo();

    public TerrainRenderContext() {
        this.overlay = OverlayTexture.DEFAULT_UV;
        this.blockInfo.random = Random.create();
    }

    @Override
    protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
        return new AoCalculator(blockInfo){

            @Override
            public int light(BlockPos pos, BlockState state) {
                return TerrainRenderContext.this.chunkInfo.cachedBrightness(pos, state);
            }

            @Override
            public float ao(BlockPos pos, BlockState state) {
                return TerrainRenderContext.this.chunkInfo.cachedAoLevel(pos, state);
            }
        };
    }

    @Override
    protected VertexConsumer getVertexConsumer(RenderLayer layer) {
        return this.chunkInfo.getInitializedBuffer(layer);
    }

    public void prepare(ChunkRendererRegion blockView, ChunkBuilder.BuiltChunk chunkRenderer, ChunkBuilder.BuiltChunk.RebuildTask.RenderData renderData, BlockBufferBuilderStorage builders, Set<RenderLayer> initializedLayers) {
        this.blockInfo.prepareForWorld((BlockRenderView)blockView, true);
        this.chunkInfo.prepare(blockView, chunkRenderer, renderData, builders, initializedLayers);
    }

    public void release() {
        this.chunkInfo.release();
        this.blockInfo.release();
    }

    public void tessellateBlock(BlockState blockState, BlockPos blockPos, BakedModel model, MatrixStack matrixStack) {
        try {
            Vec3d offset = blockState.getModelOffset((BlockView)this.chunkInfo.blockView, blockPos);
            matrixStack.translate(offset.x, offset.y, offset.z);
            this.matrix = matrixStack.peek().getPositionMatrix();
            this.normalMatrix = matrixStack.peek().getNormalMatrix();
            this.blockInfo.recomputeSeed = true;
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockState, blockPos, model.useAmbientOcclusion());
            model.emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.create((Throwable)throwable, (String)"Tessellating block in world - Indigo Renderer");
            CrashReportSection crashReportSection = crashReport.addElement("Block being tessellated");
            CrashReportSection.addBlockInfo((CrashReportSection)crashReportSection, (HeightLimitView)this.chunkInfo.blockView, (BlockPos)blockPos, (BlockState)blockState);
            throw new CrashException(crashReport);
        }
    }
}

