/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.renderer.VanillaModelEncoder;
import net.minecraft.block.BlockState;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.RenderLayers;
import net.minecraft.client.render.TexturedRenderLayers;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.item.ItemRenderer;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.random.Random;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final ItemColors colorMap;
    private final Random random = Random.create();
    private final Supplier<Random> randomSupplier = () -> {
        this.random.setSeed(42L);
        return this.random;
    };
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.renderQuad(this);
        }
    };
    private final BakedModelConsumerImpl vanillaModelConsumer = new BakedModelConsumerImpl();
    private ItemStack itemStack;
    private ModelTransformationMode transformMode;
    private MatrixStack matrixStack;
    private VertexConsumerProvider vertexConsumerProvider;
    private int lightmap;
    private boolean isDefaultTranslucent;
    private boolean isTranslucentDirect;
    private boolean isDefaultGlint;
    private VertexConsumer translucentVertexConsumer;
    private VertexConsumer cutoutVertexConsumer;
    private VertexConsumer translucentGlintVertexConsumer;
    private VertexConsumer cutoutGlintVertexConsumer;

    public ItemRenderContext(ItemColors colorMap) {
        this.colorMap = colorMap;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public boolean isFaceCulled(@Nullable Direction face) {
        throw new IllegalStateException("isFaceCulled can only be called on a block render context.");
    }

    public ModelTransformationMode itemTransformationMode() {
        return this.transformMode;
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.vanillaModelConsumer;
    }

    public void renderModel(ItemStack itemStack, ModelTransformationMode transformMode, boolean invert, MatrixStack matrixStack, VertexConsumerProvider vertexConsumerProvider, int lightmap, int overlay, BakedModel model) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.computeOutputInfo();
        this.matrix = matrixStack.peek().getPositionMatrix();
        this.normalMatrix = matrixStack.peek().getNormalMatrix();
        model.emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        this.itemStack = null;
        this.matrixStack = null;
        this.vertexConsumerProvider = null;
        this.translucentVertexConsumer = null;
        this.cutoutVertexConsumer = null;
        this.translucentGlintVertexConsumer = null;
        this.cutoutGlintVertexConsumer = null;
    }

    private void computeOutputInfo() {
        this.isDefaultTranslucent = true;
        this.isTranslucentDirect = true;
        Item item = this.itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.getBlock().getDefaultState();
            RenderLayer renderLayer = RenderLayers.getBlockLayer((BlockState)state);
            if (renderLayer != RenderLayer.getTranslucent()) {
                this.isDefaultTranslucent = false;
            }
            if (this.transformMode != ModelTransformationMode.GUI && !this.transformMode.isFirstPerson()) {
                this.isTranslucentDirect = false;
            }
        }
        this.isDefaultGlint = this.itemStack.hasGlint();
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        boolean emissive = mat.emissive();
        VertexConsumer vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glint());
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int itemColor = 0xFF000000 | this.colorMap.getColor(this.itemStack, colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(itemColor, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private VertexConsumer getVertexConsumer(BlendMode blendMode, TriState glintMode) {
        boolean glint;
        boolean translucent;
        if (blendMode == BlendMode.DEFAULT) {
            translucent = this.isDefaultTranslucent;
        } else {
            boolean bl = translucent = blendMode == BlendMode.TRANSLUCENT;
        }
        if (glintMode == TriState.DEFAULT) {
            glint = this.isDefaultGlint;
        } else {
            boolean bl = glint = glintMode == TriState.TRUE;
        }
        if (translucent) {
            if (glint) {
                if (this.translucentGlintVertexConsumer == null) {
                    this.translucentGlintVertexConsumer = this.createTranslucentVertexConsumer(true);
                }
                return this.translucentGlintVertexConsumer;
            }
            if (this.translucentVertexConsumer == null) {
                this.translucentVertexConsumer = this.createTranslucentVertexConsumer(false);
            }
            return this.translucentVertexConsumer;
        }
        if (glint) {
            if (this.cutoutGlintVertexConsumer == null) {
                this.cutoutGlintVertexConsumer = this.createCutoutVertexConsumer(true);
            }
            return this.cutoutGlintVertexConsumer;
        }
        if (this.cutoutVertexConsumer == null) {
            this.cutoutVertexConsumer = this.createCutoutVertexConsumer(false);
        }
        return this.cutoutVertexConsumer;
    }

    private VertexConsumer createTranslucentVertexConsumer(boolean glint) {
        if (this.isTranslucentDirect) {
            return ItemRenderer.getDirectItemGlintConsumer((VertexConsumerProvider)this.vertexConsumerProvider, (RenderLayer)TexturedRenderLayers.getEntityTranslucentCull(), (boolean)true, (boolean)glint);
        }
        if (MinecraftClient.isFabulousGraphicsOrBetter()) {
            return ItemRenderer.getItemGlintConsumer((VertexConsumerProvider)this.vertexConsumerProvider, (RenderLayer)TexturedRenderLayers.getItemEntityTranslucentCull(), (boolean)true, (boolean)glint);
        }
        return ItemRenderer.getItemGlintConsumer((VertexConsumerProvider)this.vertexConsumerProvider, (RenderLayer)TexturedRenderLayers.getEntityTranslucentCull(), (boolean)true, (boolean)glint);
    }

    private VertexConsumer createCutoutVertexConsumer(boolean glint) {
        return ItemRenderer.getDirectItemGlintConsumer((VertexConsumerProvider)this.vertexConsumerProvider, (RenderLayer)TexturedRenderLayers.getEntityCutout(), (boolean)true, (boolean)glint);
    }

    @Environment(value=EnvType.CLIENT)
    private class BakedModelConsumerImpl
    implements RenderContext.BakedModelConsumer {
        private BakedModelConsumerImpl() {
        }

        public void accept(BakedModel model) {
            this.accept(model, null);
        }

        public void accept(BakedModel model, @Nullable BlockState state) {
            VanillaModelEncoder.emitItemQuads((BakedModel)model, (BlockState)state, ItemRenderContext.this.randomSupplier, (RenderContext)ItemRenderContext.this);
        }
    }
}

