/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.BufferBuilder;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.chunk.BlockBufferBuilderStorage;
import net.minecraft.client.render.chunk.ChunkBuilder;
import net.minecraft.client.render.chunk.ChunkRendererRegion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BlockRenderView;
import net.minecraft.world.BlockView;

@Environment(value=EnvType.CLIENT)
public class ChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache;
    private final Long2FloatOpenHashMap aoLevelCache;
    private final BlockPos.Mutable chunkOrigin = new BlockPos.Mutable();
    ChunkBuilder.BuiltChunk.RebuildTask.RenderData renderData;
    ChunkBuilder.BuiltChunk chunkRenderer;
    BlockBufferBuilderStorage builders;
    Set<RenderLayer> initializedLayers;
    BlockRenderView blockView;
    private final Object2ObjectOpenHashMap<RenderLayer, BufferBuilder> buffers = new Object2ObjectOpenHashMap();

    ChunkRenderInfo() {
        this.brightnessCache = new Long2IntOpenHashMap();
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void prepare(ChunkRendererRegion blockView, ChunkBuilder.BuiltChunk chunkRenderer, ChunkBuilder.BuiltChunk.RebuildTask.RenderData renderData, BlockBufferBuilderStorage builders, Set<RenderLayer> initializedLayers) {
        this.blockView = blockView;
        this.chunkOrigin.set((Vec3i)chunkRenderer.getOrigin());
        this.renderData = renderData;
        this.chunkRenderer = chunkRenderer;
        this.builders = builders;
        this.initializedLayers = initializedLayers;
        this.buffers.clear();
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
    }

    void release() {
        this.renderData = null;
        this.chunkRenderer = null;
        this.buffers.clear();
    }

    public BufferBuilder getInitializedBuffer(RenderLayer renderLayer) {
        BufferBuilder builder = (BufferBuilder)this.buffers.get((Object)renderLayer);
        if (builder == null) {
            builder = this.builders.get(renderLayer);
            if (this.initializedLayers.add(renderLayer)) {
                this.chunkRenderer.beginBufferBuilding(builder);
            }
            this.buffers.put((Object)renderLayer, (Object)builder);
        }
        return builder;
    }

    int cachedBrightness(BlockPos pos, BlockState state) {
        long key = pos.asLong();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = AoCalculator.getLightmapCoordinates(this.blockView, state, pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(BlockPos pos, BlockState state) {
        long key = pos.asLong();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = AoLuminanceFix.INSTANCE.apply((BlockView)this.blockView, pos, state);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

