/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.RenderLayers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.BlockRenderView;
import net.minecraft.world.BlockView;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlockRenderInfo {
    private final BlockColors blockColorMap = MinecraftClient.getInstance().getBlockColors();
    private final BlockPos.Mutable searchPos = new BlockPos.Mutable();
    public BlockRenderView blockView;
    public BlockPos blockPos;
    public BlockState blockState;
    boolean useAo;
    boolean defaultAo;
    RenderLayer defaultLayer;
    Random random;
    long seed;
    boolean recomputeSeed;
    public final Supplier<Random> randomSupplier = () -> {
        long seed = this.seed;
        if (this.recomputeSeed) {
            this.seed = seed = this.blockState.getRenderingSeed(this.blockPos);
            this.recomputeSeed = false;
        }
        Random random = this.random;
        random.setSeed(seed);
        return random;
    };
    private boolean enableCulling;
    private int cullCompletionFlags;
    private int cullResultFlags;

    public void prepareForWorld(BlockRenderView blockView, boolean enableCulling) {
        this.blockView = blockView;
        this.enableCulling = enableCulling;
    }

    public void prepareForBlock(BlockState blockState, BlockPos blockPos, boolean modelAo) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.useAo = MinecraftClient.isAmbientOcclusionEnabled();
        this.defaultAo = this.useAo && modelAo && blockState.getLuminance() == 0;
        this.defaultLayer = RenderLayers.getBlockLayer((BlockState)blockState);
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    public void release() {
        this.blockView = null;
        this.blockPos = null;
        this.blockState = null;
    }

    int blockColor(int colorIndex) {
        return 0xFF000000 | this.blockColorMap.getColor(this.blockState, this.blockView, this.blockPos, colorIndex);
    }

    boolean shouldDrawFace(@Nullable Direction face) {
        if (face == null || !this.enableCulling) {
            return true;
        }
        int mask = 1 << face.getId();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (Block.shouldDrawSide((BlockState)this.blockState, (BlockView)this.blockView, (BlockPos)this.blockPos, (Direction)face, (BlockPos)this.searchPos.set((Vec3i)this.blockPos, face))) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }

    RenderLayer effectiveRenderLayer(BlendMode blendMode) {
        return blendMode == BlendMode.DEFAULT ? this.defaultLayer : blendMode.blockRenderLayer;
    }
}

