/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.conditions;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.registry.tag.TagManagerLoader;
import net.minecraft.resource.featuretoggle.FeatureFlag;
import net.minecraft.resource.featuretoggle.FeatureFlags;
import net.minecraft.resource.featuretoggle.FeatureSet;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceConditionsImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fabric Resource Conditions");
    public static final ThreadLocal<Map<RegistryKey<?>, Map<Identifier, Collection<RegistryEntry<?>>>>> LOADED_TAGS = new ThreadLocal();
    public static final ThreadLocal<FeatureSet> CURRENT_FEATURES = ThreadLocal.withInitial(() -> FeatureFlags.DEFAULT_ENABLED_FEATURES);
    public static final ThreadLocal<DynamicRegistryManager.Immutable> CURRENT_REGISTRIES = new ThreadLocal();

    public static ConditionJsonProvider array(final Identifier id, final ConditionJsonProvider ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one value.");
        return new ConditionJsonProvider(){

            @Override
            public Identifier getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (ConditionJsonProvider provider : values) {
                    array.add((JsonElement)provider.toJson());
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    public static ConditionJsonProvider mods(final Identifier id, final String ... modIds) {
        Preconditions.checkArgument((modIds.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one mod id.");
        return new ConditionJsonProvider(){

            @Override
            public Identifier getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (String modId : modIds) {
                    array.add(modId);
                }
                object.add("values", (JsonElement)array);
            }
        };
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider tagsPopulated(final Identifier id, final boolean includeRegistry, final TagKey<T> ... tags) {
        Preconditions.checkArgument((tags.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one tag.");
        final RegistryKey registryRef = tags[0].registry();
        return new ConditionJsonProvider(){

            @Override
            public Identifier getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (TagKey tag : tags) {
                    array.add(tag.id().toString());
                }
                object.add("values", (JsonElement)array);
                if (includeRegistry && registryRef != RegistryKeys.ITEM) {
                    object.addProperty("registry", registryRef.getValue().toString());
                }
            }
        };
    }

    public static ConditionJsonProvider featuresEnabled(final Identifier id, FeatureFlag ... features) {
        final TreeSet ids = new TreeSet(FeatureFlags.FEATURE_MANAGER.toId(FeatureFlags.FEATURE_MANAGER.featureSetOf(features)));
        return new ConditionJsonProvider(){

            @Override
            public Identifier getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (Identifier id2 : ids) {
                    array.add(id2.toString());
                }
                object.add("features", (JsonElement)array);
            }
        };
    }

    public static ConditionJsonProvider registryContains(final Identifier id, final Identifier registry, final Identifier ... entries) {
        Preconditions.checkArgument((entries.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one entry.");
        return new ConditionJsonProvider(){

            @Override
            public Identifier getConditionId() {
                return id;
            }

            @Override
            public void writeParameters(JsonObject object) {
                JsonArray array = new JsonArray();
                for (Identifier entry : entries) {
                    array.add(entry.toString());
                }
                object.add("values", (JsonElement)array);
                if (!RegistryKeys.ITEM.getValue().equals((Object)registry)) {
                    object.addProperty("registry", registry.toString());
                }
            }
        };
    }

    public static boolean modsLoadedMatch(JsonObject object, boolean and) {
        JsonArray array = JsonHelper.getArray((JsonObject)object, (String)"values");
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                if (FabricLoader.getInstance().isModLoaded(element.getAsString()) == and) continue;
                return !and;
            }
            throw new JsonParseException("Invalid mod id entry: " + String.valueOf(element));
        }
        return and;
    }

    public static void setTags(List<TagManagerLoader.RegistryTags<?>> tags) {
        HashMap<RegistryKey, Map> tagMap = new HashMap<RegistryKey, Map>();
        for (TagManagerLoader.RegistryTags<?> registryTags : tags) {
            tagMap.put(registryTags.key(), registryTags.tags());
        }
        LOADED_TAGS.set(tagMap);
    }

    public static boolean tagsPopulatedMatch(JsonObject object) {
        String key = JsonHelper.getString((JsonObject)object, (String)"registry", (String)"minecraft:item");
        RegistryKey registryRef = RegistryKey.ofRegistry((Identifier)new Identifier(key));
        return ResourceConditionsImpl.tagsPopulatedMatch(object, registryRef);
    }

    public static boolean tagsPopulatedMatch(JsonObject object, RegistryKey<? extends Registry<?>> registryKey) {
        JsonArray array = JsonHelper.getArray((JsonObject)object, (String)"values");
        @Nullable Map<RegistryKey<?>, Map<Identifier, Collection<RegistryEntry<?>>>> allTags = LOADED_TAGS.get();
        if (allTags == null) {
            LOGGER.warn("Can't retrieve deserialized tags. Failing tags_populated resource condition check.");
            return false;
        }
        Map<Identifier, Collection<RegistryEntry<?>>> registryTags = allTags.get(registryKey);
        if (registryTags == null) {
            return array.isEmpty();
        }
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                Identifier id = new Identifier(element.getAsString());
                Collection<RegistryEntry<?>> tags = registryTags.get(id);
                if (tags != null && !tags.isEmpty()) continue;
                return false;
            }
            throw new JsonParseException("Invalid tag id entry: " + String.valueOf(element));
        }
        return true;
    }

    public static boolean featuresEnabledMatch(JsonObject object) {
        List<Identifier> featureIds = JsonHelper.getArray((JsonObject)object, (String)"features").asList().stream().map(element -> new Identifier(element.getAsString())).toList();
        FeatureSet set = FeatureFlags.FEATURE_MANAGER.featureSetOf(featureIds, id -> {
            throw new JsonParseException("Unknown feature flag: " + String.valueOf(id));
        });
        return set.isSubsetOf(CURRENT_FEATURES.get());
    }

    public static boolean registryContainsMatch(JsonObject object) {
        String key = JsonHelper.getString((JsonObject)object, (String)"registry", (String)"minecraft:item");
        RegistryKey registryRef = RegistryKey.ofRegistry((Identifier)new Identifier(key));
        return ResourceConditionsImpl.registryContainsMatch(object, registryRef);
    }

    private static <E> boolean registryContainsMatch(JsonObject object, RegistryKey<? extends Registry<? extends E>> registryRef) {
        JsonArray array = JsonHelper.getArray((JsonObject)object, (String)"values");
        DynamicRegistryManager.Immutable registries = CURRENT_REGISTRIES.get();
        if (registries == null) {
            LOGGER.warn("Can't retrieve current registries. Failing registry_contains resource condition check.");
            return false;
        }
        Optional registry = registries.getOptional(registryRef);
        if (registry.isEmpty()) {
            return array.isEmpty();
        }
        for (JsonElement element : array) {
            if (element.isJsonPrimitive()) {
                Identifier id = new Identifier(element.getAsString());
                if (((Registry)registry.get()).containsId(id)) continue;
                return false;
            }
            throw new JsonParseException("Invalid registry entry id: " + String.valueOf(element));
        }
        return true;
    }
}

