/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.resource.conditions.v1;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import org.jetbrains.annotations.Nullable;

public final class ResourceConditions {
    private static final Map<Identifier, Predicate<JsonObject>> REGISTERED_CONDITIONS = new ConcurrentHashMap<Identifier, Predicate<JsonObject>>();
    public static final String CONDITIONS_KEY = "fabric:load_conditions";
    public static final String CONDITION_ID_KEY = "condition";

    public static void register(Identifier identifier, Predicate<JsonObject> condition) {
        Objects.requireNonNull(identifier, "Identifier may not be null.");
        Objects.requireNonNull(condition, "Condition may not be null.");
        if (REGISTERED_CONDITIONS.put(identifier, condition) != null) {
            throw new IllegalArgumentException("Duplicate JSON condition registration with id " + String.valueOf(identifier));
        }
    }

    @Nullable
    public static Predicate<JsonObject> get(Identifier identifier) {
        return REGISTERED_CONDITIONS.get(identifier);
    }

    public static boolean objectMatchesConditions(JsonObject object) {
        try {
            JsonArray conditions = JsonHelper.getArray((JsonObject)object, (String)CONDITIONS_KEY, null);
            if (conditions == null) {
                return true;
            }
            return ResourceConditions.conditionsMatch(conditions, true);
        }
        catch (RuntimeException exception) {
            ResourceConditionsImpl.LOGGER.warn("Skipping object %s. Failed to parse resource conditions".formatted(object), (Throwable)exception);
            return false;
        }
    }

    public static boolean conditionsMatch(JsonArray conditions, boolean and) throws RuntimeException {
        for (JsonElement element : conditions) {
            if (element.isJsonObject()) {
                if (ResourceConditions.conditionMatches(element.getAsJsonObject()) == and) continue;
                return !and;
            }
            throw new JsonParseException("Invalid condition entry: " + String.valueOf(element));
        }
        return and;
    }

    public static boolean conditionMatches(JsonObject condition) throws RuntimeException {
        Identifier conditionId = new Identifier(JsonHelper.getString((JsonObject)condition, (String)CONDITION_ID_KEY));
        Predicate<JsonObject> jrc = ResourceConditions.get(conditionId);
        if (jrc == null) {
            throw new JsonParseException("Unknown recipe condition: " + String.valueOf(conditionId));
        }
        return jrc.test(condition);
    }

    private ResourceConditions() {
    }

    static {
        DefaultResourceConditions.init();
    }
}

