/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.lifecycle.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.ServerWorld;

public final class ServerWorldEvents {
    public static final Event<Load> LOAD = EventFactory.createArrayBacked(Load.class, callbacks -> (server, world) -> {
        for (Load callback : callbacks) {
            callback.onWorldLoad(server, world);
        }
    });
    public static final Event<Unload> UNLOAD = EventFactory.createArrayBacked(Unload.class, callbacks -> (server, world) -> {
        for (Unload callback : callbacks) {
            callback.onWorldUnload(server, world);
        }
    });

    private ServerWorldEvents() {
    }

    @FunctionalInterface
    public static interface Unload {
        public void onWorldUnload(MinecraftServer var1, ServerWorld var2);
    }

    @FunctionalInterface
    public static interface Load {
        public void onWorldLoad(MinecraftServer var1, ServerWorld var2);
    }
}

