/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.item;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.item.v1.CustomDamageHandler;
import net.fabricmc.fabric.api.item.v1.FabricItemStack;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.impl.item.ItemExtensions;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.attribute.EntityAttribute;
import net.minecraft.entity.attribute.EntityAttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements FabricItemStack {
    @Unique
    private LivingEntity fabric_damagingEntity;
    @Unique
    private Consumer<LivingEntity> fabric_breakCallback;

    @Shadow
    public abstract Item method_7909();

    @Inject(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")})
    private void saveDamager(int amount, LivingEntity entity, Consumer<LivingEntity> breakCallback, CallbackInfo ci) {
        this.fabric_damagingEntity = entity;
        this.fabric_breakCallback = breakCallback;
    }

    @ModifyArg(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/util/math/random/Random;Lnet/minecraft/server/network/ServerPlayerEntity;)Z"), index=0)
    private int hookDamage(int amount) {
        CustomDamageHandler handler = ((ItemExtensions)this.method_7909()).fabric_getCustomDamageHandler();
        if (handler != null) {
            return handler.damage((ItemStack)this, amount, this.fabric_damagingEntity, this.fabric_breakCallback);
        }
        return amount;
    }

    @Inject(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="RETURN")})
    private <T extends LivingEntity> void clearDamage(int amount, T entity, Consumer<T> breakCallback, CallbackInfo ci) {
        this.fabric_damagingEntity = null;
        this.fabric_breakCallback = null;
    }

    @Redirect(method={"getAttributeModifiers"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;getAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    public Multimap<EntityAttribute, EntityAttributeModifier> hookGetAttributeModifiers(Item item, EquipmentSlot slot) {
        ItemStack stack = (ItemStack)this;
        LinkedHashMultimap attributeModifiers = LinkedHashMultimap.create((Multimap)item.getAttributeModifiers(stack, slot));
        ((ModifyItemAttributeModifiersCallback)ModifyItemAttributeModifiersCallback.EVENT.invoker()).modifyAttributeModifiers(stack, slot, (Multimap<EntityAttribute, EntityAttributeModifier>)attributeModifiers);
        return attributeModifiers;
    }

    @Redirect(method={"isSuitableFor"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;isSuitableFor(Lnet/minecraft/block/BlockState;)Z"))
    public boolean hookIsSuitableFor(Item item, BlockState state) {
        return item.isSuitableFor((ItemStack)this, state);
    }
}

