/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.server;

import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

@Deprecated
public final class PlayerStream {
    private PlayerStream() {
    }

    public static Stream<ServerPlayerEntity> all(MinecraftServer server) {
        if (server.getPlayerManager() != null) {
            return server.getPlayerManager().getPlayerList().stream();
        }
        return Stream.empty();
    }

    public static Stream<PlayerEntity> world(World world) {
        if (world instanceof ServerWorld) {
            return ((ServerWorld)world).getPlayers().stream();
        }
        throw new RuntimeException("Only supported on ServerWorld!");
    }

    public static Stream<PlayerEntity> watching(World world, ChunkPos pos) {
        if (world instanceof ServerWorld) {
            return PlayerLookup.tracking((ServerWorld)((ServerWorld)world), (ChunkPos)pos).stream();
        }
        throw new RuntimeException("Only supported on ServerWorld!");
    }

    public static Stream<PlayerEntity> watching(Entity entity) {
        return PlayerLookup.tracking((Entity)entity).stream();
    }

    public static Stream<PlayerEntity> watching(BlockEntity entity) {
        return PlayerStream.watching(entity.getWorld(), entity.getPos());
    }

    public static Stream<PlayerEntity> watching(World world, BlockPos pos) {
        return PlayerStream.watching(world, new ChunkPos(pos));
    }

    public static Stream<PlayerEntity> around(World world, Vec3d vector, double radius) {
        double radiusSq = radius * radius;
        return PlayerStream.world(world).filter(p -> p.squaredDistanceTo(vector) <= radiusSq);
    }

    public static Stream<PlayerEntity> around(World world, BlockPos pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerStream.world(world).filter(p -> p.squaredDistanceTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= radiusSq);
    }
}

