/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.dimension;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.impl.dimension.Teleportable;
import net.minecraft.entity.Entity;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.world.TeleportTarget;

public final class FabricDimensionInternals {
    private FabricDimensionInternals() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Entity> E changeDimension(E teleported, ServerWorld dimension, TeleportTarget target) {
        Preconditions.checkArgument((!teleported.getWorld().isClient ? 1 : 0) != 0, (Object)"Entities can only be teleported on the server side");
        Preconditions.checkArgument((Thread.currentThread() == ((ServerWorld)teleported.getWorld()).getServer().getThread() ? 1 : 0) != 0, (Object)"Entities must be teleported from the main server thread");
        try {
            ((Teleportable)teleported).fabric_setCustomTeleportTarget(target);
            if (teleported.getWorld() == dimension) {
                if (teleported instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)teleported;
                    serverPlayerEntity.networkHandler.requestTeleport(target.position.x, target.position.y, target.position.z, target.yaw, teleported.getPitch());
                } else {
                    teleported.refreshPositionAndAngles(target.position.x, target.position.y, target.position.z, target.yaw, teleported.getPitch());
                }
                teleported.setVelocity(target.velocity);
                teleported.setHeadYaw(target.yaw);
                E e = teleported;
                return e;
            }
            Entity entity = teleported.moveToWorld(dimension);
            return (E)entity;
        }
        finally {
            ((Teleportable)teleported).fabric_setCustomTeleportTarget(null);
        }
    }
}

